    #######################################################
    # (C) 2021 T. Risset
    # Code compiled from the follwing program with -O0 option
    # riscv64-linux-gnu-gcc -S whileLoop.c -o whileLoop.S -O0
    # and manually adapted to qtrvsim
    # int main()
    # {
    #   int x = 10;
    #   while (x != 0)
    #      x = x-1;
    #   return x;
    # }
    #######################################################

#pragma qtrvsim show terminal
#pragma qtrvsim show registers
#pragma qtrvsim show memory

.globl _start
.globl __start
    
.org 0x00000200

.text

__start:
_start:
    addi    sp,sp,-32    # reserve 32 bytes in stack
    sw    s0,24(sp)      # Store s0 in stack (s0 used by function)
    addi    s0,sp,32     # s0 <- fp (frame pointer)
    li    a5,10          # a5 <- 10
    sw    a5,-20(s0)     # Store a5 in stack
    j    L2
L3:
    lw    a5,-20(s0)     # get a5 from stack
    addi    a5,a5,-1    # a5 <- a5 - 1
    sw    a5,-20(s0)     # store a5 in stack
L2:
    lw    a5,-20(s0)     # get a5 from stack 
    bne    a5,zero,L3    # branch L3 is a5 != 0
    lw    a5,-20(s0)     # get a5 from stack again (here a5 = 0)
    mv    a0,a5          # a0 <- a5 (result of main)
    lw    s0,24(sp)      # restore s0
    addi    sp,sp,32     # restore sp
    jr    ra             # return from main

#pragma qtrvsim tab core
