#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "graphe_adj_type.h"
#include "graphe_poids_type.h"
#include "graphe_liste_type.h"
#include "graphe_flot_type.h"
#include "util_adj.h"
#include "util_poids.h"
#include "util_flot.h"
#include "graphe.h"
#include "graphe_liste.h"
#include "graphe_flot.h"

int main()
{
  GRAPHE g1,g2;
  GRAPHE_FLOT g3;
  g3=read_flot_mat("flot_ex2.mat");
  affiche_flot_mat(stdout,g3); 

 
  affiche_flot_dot("flot_ex2.dot",g3);
  printf("OK\n");

  int adm=flot_admissible(g3);
  if (!adm)
    printf("Flot non admissible pour g3\n");
  else 
    printf("Flot admissible pour g3\n");
  int cons=flot_conservatif(g3,11,10);
  if (!cons)
    printf("Flot non conservatif pour g3\n");
  else 
    printf("Flot conservatif pour g3\n");

  printf("Cut=%d\n",cut(g3,11,10));
	
  printf("old flot=%d\n",valeur_flot(g3, 11,10));
  ford_fulkerson(g3,11,10);
  affiche_flot_mat(stdout,g3); 
  dotty_flot_dot(g3);
  
  adm=flot_admissible(g3);
  if (!adm)
    printf("Flot non admissible pour g3\n");
  else 
    printf("Flot admissible pour g3\n");
  cons=flot_conservatif(g3,11,10);
  if (!cons)
    printf("Flot non conservatif pour g3\n");
  else 
    printf("Flot conservatif pour g3\n");

  printf("new Cut=%d\n",cut(g3,11,10));

  printf("new flot=%d\n",valeur_flot(g3, 11,10));
  affiche_flot_dot("sol_flot_ex2.dot",g3);
	  
  printf("OK\n");

  return 0;
}
