#include <stdio.h>
#include <stdlib.h> 
#include <string.h> 
#include <unistd.h> 
#include <errno.h> 
#include <sys/types.h> 
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>


/* exemple d'un serveur TCP simple */


int main(int argc, char *argv[])
{
    int sock_serv; 
    int sock_len=sizeof(struct sockaddr_in);
    struct sockaddr_in listen_addr;
    
    /* Creation de la socket */ 
    if ((sock_serv=socket(AF_INET,SOCK_STREAM,0)) == -1)
      {
	perror("Creation de socket impossible"); 
	return -1; 
      } 
    
    /* Preparation de l'adresse d'ecoute: 
       l'adresse sur laquelle nous allons nous connecter */ 
    listen_addr.sin_family=AF_INET; 
    
    /* INADDR_ANY: En tant que serveur, nous acceptons n'importe quelle adresse
       Attention: Conversion (interne) -> (reseau) avec htonl et htons 
       On écoute sur le port 20000 */
    listen_addr.sin_addr.s_addr=htonl(INADDR_ANY); 
    listen_addr.sin_port=htons(20000);

        /* Demande d'attachement de la socket */ 
    if (bind(sock_serv,(struct sockaddr*)&listen_addr,sock_len) == -1)
      {
	perror("Attachement de la socket impossible"); 
	exit(errno);
      }

        

    /* en ecoute: une seule requète traitée */
    if(listen(sock_serv, 1) == -1)
      {
	perror("listen impossible");
	exit(errno);
      }

    printf("Listenning to connection....\n");

    int socket_service;
    socklen_t sock_serv_len=sizeof(struct sockaddr_in);
    socket_service=accept(sock_serv,(struct sockaddr*) &listen_addr, &sock_serv_len);
    if (socket_service == -1)
      {
	perror ("Connect failed"); 
	exit(errno);
      }
    
    printf("Connection accepted on port number %d\n", ntohs(listen_addr.sin_port));

    int buf_len=100 , n;
    char buffer[buf_len];
    while (1)
      {
	memset(buffer,0,buf_len);
	if((n = recv(socket_service, buffer, buf_len, 0)) < 0)
	  {
	    perror("could not recv()");
	    exit(errno);
	  }
	
	buffer[n] = '\0';
	printf("reveived message of size %d : %s\n",n,buffer);
      }
    return 0;
    
}


