#include <stdio.h>
#include <stdlib.h> 
#include <string.h> 
#include <unistd.h> 
#include <errno.h> 
#include <sys/types.h> 
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>


/* exemple d'un serveur TCP simple */


int main(int argc, char *argv[])
{
    int socket_connection; 
    int sock_connection_len=sizeof(struct sockaddr_in);
    struct sockaddr_in listen_addr;
    
    /* Creation de la socket */ 
    if ((socket_connection=socket(AF_INET,SOCK_STREAM,0)) == -1)
      {
	perror("Creation de socket impossible"); 
	return -1; 
      } 
    
    /* Preparation de l'adresse d'ecoute: 
       l'adresse sur laquelle nous allons nous connecter */ 
    listen_addr.sin_family=AF_INET; 
    
    /* INADDR_ANY: En tant que serveur, nous acceptons n'importe quelle adresse
       Attention: Conversion (interne) -> (reseau) avec htonl et htons 
       On écoute sur le port 20000 */
    listen_addr.sin_addr.s_addr=htonl(INADDR_ANY); 
    listen_addr.sin_port=htons(20000);

        /* Demande d'attachement de la socket */ 
    if (bind(socket_connection,(struct sockaddr*)&listen_addr,sock_connection_len) == -1)
      {
	perror("Attachement de la socket impossible"); 
	exit(errno);
      }

        

    /* en ecoute: une seule requète traitée */
    if(listen(socket_connection, 1) == -1)
      {
	perror("listen impossible");
	exit(errno);
      }

    printf("Listenning to connection....on port %d\n",20000);

    int socket_client;
    struct sockaddr_in client_addr;
    socklen_t sock_client_len=sizeof(struct sockaddr_in);

    socket_client=accept(socket_connection,(struct sockaddr*) &client_addr, &sock_client_len);
    
    if (socket_client == -1)
      {
	perror ("Connect failed"); 
	exit(errno);
      }
    
    printf("Connection accepted on port number %d\n", ntohs(client_addr.sin_port));

    
    return 0;
    
}


