#include <stdio.h>
#include "pile.h"
#include "hanoi.h"

/*!***********************************************
* \brief     dplace le sommet de pile d'une pile source (*psource) vers une pile destination (*pdest)
* \param psource un pointeur vers la pile source  
* \param pdest un pointeur vers la pile destination  
* \pre Les deux piles pointes par psource et pdest sont 
        des piles de Hanoi valides (chaque lment est plus petit 
	que le suivant dans la pile). La pile pointe par psource 
	est non-vide. ppile pointe sur une pile valide
* \post Si le sommet de la pile pointe par psource
est de plus petite taille que le sommet de la pile pointe par 
pdest les deux piles sont modifies: le sommet de pile de *psource 
est enlev et rajout  *pdest, Sinon la fonction affiche une 
erreur et  interrompt le programme. 
* \result La fonction renvoie 0 si aucune erreur n'est intervenue  
**************************************************/    
int deplacer(PILE *psource, PILE *pdest)
{int element;

 if (*psource==NULL) error1("deplacer: pile source vide");
 element=Depiler(psource);
 if (*pdest!=NULL) 
   if (element > (*pdest)->elem)
     error1("deplacer: opration invalide");
 Empiler(pdest,element);
 return(0);
}
/*****************************************************************/


/*!***********************************************
* \brief resoud le problme de Hanoi de taille N de la pile *pdpart vers la pile *parrive en utilisant la pile de passage *ppassage.
* \param pdepart un pointeur vers la pile de dpart  
* \param parrive un pointeur vers la pile d'arrive  
* \param ppassage un pointeur vers la pile de passage
* \param N Le nombre d'lments  transferer de *pdepart  *parrive
* \pre Les trois piles pointes par pdepart, ppassage et 
        parrive sont des piles de Hanoi valides (chaque lment est plus 
	petit que le suivant dans la pile). Les piles pointes par ppassage 
	et parrive sont telles qu'elle peuvent empiler les N premiers 
	lments de la pile pointe par pdepart. 
* \post  Une tour de Hanoi de taille N a t dplace de la pile 
	pointe par pdepart vers la pile pointe par parrive uniquement en 
	utilisant des dplacements valides. Si La tour de dpart contient moins
	de N lments ou si le dplacement est impossible, une erreur 
	doit interompre le programme 
* \result La fonction renvoie 0 si aucune erreur n'est intervenue  
**************************************************/    
int hanoi(PILE *pdepart,PILE *ppassage, PILE *parrive,int N)
{int element;

 if (N==0)
   {
     return(0);
   }
 else
   {
     hanoi(pdepart, parrive, ppassage, N-1);
     deplacer(pdepart, parrive);
     hanoi(ppassage, pdepart, parrive, N-1);
   }
 return(0);
}
/*****************************************************************/
