#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "graphe_adj_type.h"
#include "graphe_poids_type.h"
#include "graphe_liste_type.h"
#include "graphe_flot_type.h"
#include "graphe.h"
#include "graphe_liste.h"
#include "graphe_flot.h"
#include "util_adj.h"
#include "util_poids.h"
#include "util_flot.h"

int main()
{
  GRAPHE g1;
  GRAPHE_POIDS g3;
  GRAPHE_FLOT g4;

  printf("**************** femeture transitive ****** \n");

  g1=read_adj_mat("graphe_ex1.mat");
  fermeture_transitive2(g1);
  affiche_adj_mat(stdout,g1);
  dotty_adj_dot(g1); 

  
  printf("**************** Dijkstra ****** \n");
  g3=read_poids_mat("poids_ex1.mat");
  affiche_poids_mat(stdout,g3);
  dotty_poids_dot(g3); 
  int *dist;
  dist=dijkstra(g3,1);
  for (int i=0;i<g3.nb_sommets;i++)
    {
      printf("dist[%d]=%d\n",i+1,dist[i]);
    }


  printf("**************** Ford Fulkerson  ****** \n");
  g4=read_flot_mat("flot_ex1.mat");
  //g4=graphe_to_liste(g1);
  affiche_flot_mat(stdout,g4);
  dotty_flot_dot(g4); 
  int res=ford_fulkerson(g4,0,7);
  printf("Found flot=%d\n",res);
  affiche_flot_mat(stdout,g4);
  dotty_flot_dot(g4); 

  return 0;
}
