.global main

; -------- main --------
main:
	/* disable watchdog */
	MOV.W	#23168, &WDTCTL
    mov #0x5a80, &0x0120 ; Disable watchdog

    mov.b #3, &34 ; Init leds, output direction
    mov.b #0, &33 ; Switch them off

    ; 0b00000011
    ; 0b00000110
    ; 0b00001001
    ; 0b00001100
    ; 0b00001111
    ; 0b00010010
    ; 0b00010101
    ; 0b00011000
    ; 0b00011011
    ; 0b00011110

    mov #1, r14
table_beg:
    mov #3, r15
    call #mul
    call #disp_led
    call #wait
    call #wait
    add #1, r14
    cmp #11, r14
    jnz table_beg

loop:
    jmp loop

; -------- wait --------
wait:
    push r15
    mov #0xffff, r15
wait_loop:
    nop
    sub #1, r15
    jnz wait_loop
    nop

    pop r15
    ret

; -------- disp_led --------
disp_led:
    ; r15 = arg
    ; r14 = i
    ; r13 = timer counter
    ; r12 = P1OUT value

    push r15
    push r14
    push r13
    push r12

    mov #8, r14

led_loop:
    mov r15, r12
    and #1, r12      ; Red led = last bit
    add #2, r12      ; Green led = 1, always
    mov.b r12, &33   ; Update leds
    call #wait

    mov.b #0, &33    ; Switch the leds off
    call #wait
    
    rra r15          ; r15 >>= 1
    sub #1, r14      ; i -= 1
    jnz led_loop     ; do while i > 0

    pop r12
    pop r13
    pop r14
    pop r15

    ret

; -------- mul --------
mul:
    ; r15 = a
    ; r14 = b
    ; r13 = tmp

    push r14
    push r13

    mov #0, r13

mul_beg:
    cmp #0, r14
    jz mul_end
    sub #1, r14
    add r15, r13
    jmp mul_beg
 
mul_end:
    mov r13, r15
    pop r13
    pop r14
    ret
    
