/*
 * protocol.h
 *
 *  Created on: Dec 14, 2023
 *      Author: bmassot
 */

#ifndef SRC_PROTOCOL_PROTOCOL_H_
#define SRC_PROTOCOL_PROTOCOL_H_


/*
 * Send a text string to interface
 * Length of string MUST be shorter than 200 characters
 */
void Protocol_SendText(char * str, size_t len);

/*
 * Send HTS221 sensor values
 */
void Protocol_SendHts221(float humidity, float temperature);

/*
 * Send LPS22HH sensor values
 */
void Protocol_SendLps22hh(float pressure, float temperature);

/*
 * Send IIS2MDCTR sensor values
 */
void Protocol_SendIi2smdctr(float mag_x, float mag_y, float mag_z);

/*
 * Send ISM330DHCX sensor values
 */
void Protocol_SendIsm330dhcx(float acc_x, float acc_y, float acc_z, float gyr_x, float gyr_y, float gyr_z);

/*
 * Send altitude value
 */
void Protocol_SendAltitude(float altitude);

#endif /* SRC_PROTOCOL_PROTOCOL_H_ */
