/* Automatically generated nanopb header */
/* Generated by nanopb-0.4.9-dev */

#ifndef PB_PROTOCOL_PB_H_INCLUDED
#define PB_PROTOCOL_PB_H_INCLUDED
#include "pb.h"

#if PB_PROTO_HEADER_VERSION != 40
#error Regenerate this file with the current version of nanopb generator.
#endif

/* Struct definitions */
typedef struct _HTS221 {
    float temperature;
    float humidity;
} HTS221;

typedef struct _LPS22HH {
    float pressure;
    float temperature;
} LPS22HH;

typedef struct _Vector3D {
    float x;
    float y;
    float z;
} Vector3D;

typedef struct _IIS2MDCTR {
    bool has_magnetometer;
    Vector3D magnetometer;
} IIS2MDCTR;

typedef struct _ISM330DHCX {
    bool has_accelerometer;
    Vector3D accelerometer;
    bool has_gyroscope;
    Vector3D gyroscope;
} ISM330DHCX;

typedef struct _UserButton {
    bool is_pushed;
} UserButton;

typedef struct _Altitude {
    float altitude;
} Altitude;

typedef struct _Console {
    char str[201];
} Console;

typedef struct _Message {
    pb_size_t which_type;
    union {
        HTS221 hts221;
        LPS22HH lps22hh;
        IIS2MDCTR iis2mdctr;
        ISM330DHCX ism330dhx;
        UserButton user_button;
        Altitude altitude;
        Console console;
    } type;
} Message;


#ifdef __cplusplus
extern "C" {
#endif

/* Initializer values for message structs */
#define HTS221_init_default                      {0, 0}
#define LPS22HH_init_default                     {0, 0}
#define Vector3D_init_default                    {0, 0, 0}
#define IIS2MDCTR_init_default                   {false, Vector3D_init_default}
#define ISM330DHCX_init_default                  {false, Vector3D_init_default, false, Vector3D_init_default}
#define UserButton_init_default                  {0}
#define Altitude_init_default                    {0}
#define Console_init_default                     {""}
#define Message_init_default                     {0, {HTS221_init_default}}
#define HTS221_init_zero                         {0, 0}
#define LPS22HH_init_zero                        {0, 0}
#define Vector3D_init_zero                       {0, 0, 0}
#define IIS2MDCTR_init_zero                      {false, Vector3D_init_zero}
#define ISM330DHCX_init_zero                     {false, Vector3D_init_zero, false, Vector3D_init_zero}
#define UserButton_init_zero                     {0}
#define Altitude_init_zero                       {0}
#define Console_init_zero                        {""}
#define Message_init_zero                        {0, {HTS221_init_zero}}

/* Field tags (for use in manual encoding/decoding) */
#define HTS221_temperature_tag                   1
#define HTS221_humidity_tag                      2
#define LPS22HH_pressure_tag                     1
#define LPS22HH_temperature_tag                  2
#define Vector3D_x_tag                           1
#define Vector3D_y_tag                           2
#define Vector3D_z_tag                           3
#define IIS2MDCTR_magnetometer_tag               1
#define ISM330DHCX_accelerometer_tag             1
#define ISM330DHCX_gyroscope_tag                 2
#define UserButton_is_pushed_tag                 1
#define Altitude_altitude_tag                    1
#define Console_str_tag                          1
#define Message_hts221_tag                       1
#define Message_lps22hh_tag                      2
#define Message_iis2mdctr_tag                    3
#define Message_ism330dhx_tag                    4
#define Message_user_button_tag                  5
#define Message_altitude_tag                     6
#define Message_console_tag                      7

/* Struct field encoding specification for nanopb */
#define HTS221_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, FLOAT,    temperature,       1) \
X(a, STATIC,   SINGULAR, FLOAT,    humidity,          2)
#define HTS221_CALLBACK NULL
#define HTS221_DEFAULT NULL

#define LPS22HH_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, FLOAT,    pressure,          1) \
X(a, STATIC,   SINGULAR, FLOAT,    temperature,       2)
#define LPS22HH_CALLBACK NULL
#define LPS22HH_DEFAULT NULL

#define Vector3D_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, FLOAT,    x,                 1) \
X(a, STATIC,   SINGULAR, FLOAT,    y,                 2) \
X(a, STATIC,   SINGULAR, FLOAT,    z,                 3)
#define Vector3D_CALLBACK NULL
#define Vector3D_DEFAULT NULL

#define IIS2MDCTR_FIELDLIST(X, a) \
X(a, STATIC,   OPTIONAL, MESSAGE,  magnetometer,      1)
#define IIS2MDCTR_CALLBACK NULL
#define IIS2MDCTR_DEFAULT NULL
#define IIS2MDCTR_magnetometer_MSGTYPE Vector3D

#define ISM330DHCX_FIELDLIST(X, a) \
X(a, STATIC,   OPTIONAL, MESSAGE,  accelerometer,     1) \
X(a, STATIC,   OPTIONAL, MESSAGE,  gyroscope,         2)
#define ISM330DHCX_CALLBACK NULL
#define ISM330DHCX_DEFAULT NULL
#define ISM330DHCX_accelerometer_MSGTYPE Vector3D
#define ISM330DHCX_gyroscope_MSGTYPE Vector3D

#define UserButton_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     is_pushed,         1)
#define UserButton_CALLBACK NULL
#define UserButton_DEFAULT NULL

#define Altitude_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, FLOAT,    altitude,          1)
#define Altitude_CALLBACK NULL
#define Altitude_DEFAULT NULL

#define Console_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, STRING,   str,               1)
#define Console_CALLBACK NULL
#define Console_DEFAULT NULL

#define Message_FIELDLIST(X, a) \
X(a, STATIC,   ONEOF,    MESSAGE,  (type,hts221,type.hts221),   1) \
X(a, STATIC,   ONEOF,    MESSAGE,  (type,lps22hh,type.lps22hh),   2) \
X(a, STATIC,   ONEOF,    MESSAGE,  (type,iis2mdctr,type.iis2mdctr),   3) \
X(a, STATIC,   ONEOF,    MESSAGE,  (type,ism330dhx,type.ism330dhx),   4) \
X(a, STATIC,   ONEOF,    MESSAGE,  (type,user_button,type.user_button),   5) \
X(a, STATIC,   ONEOF,    MESSAGE,  (type,altitude,type.altitude),   6) \
X(a, STATIC,   ONEOF,    MESSAGE,  (type,console,type.console),   7)
#define Message_CALLBACK NULL
#define Message_DEFAULT NULL
#define Message_type_hts221_MSGTYPE HTS221
#define Message_type_lps22hh_MSGTYPE LPS22HH
#define Message_type_iis2mdctr_MSGTYPE IIS2MDCTR
#define Message_type_ism330dhx_MSGTYPE ISM330DHCX
#define Message_type_user_button_MSGTYPE UserButton
#define Message_type_altitude_MSGTYPE Altitude
#define Message_type_console_MSGTYPE Console

extern const pb_msgdesc_t HTS221_msg;
extern const pb_msgdesc_t LPS22HH_msg;
extern const pb_msgdesc_t Vector3D_msg;
extern const pb_msgdesc_t IIS2MDCTR_msg;
extern const pb_msgdesc_t ISM330DHCX_msg;
extern const pb_msgdesc_t UserButton_msg;
extern const pb_msgdesc_t Altitude_msg;
extern const pb_msgdesc_t Console_msg;
extern const pb_msgdesc_t Message_msg;

/* Defines for backwards compatibility with code written before nanopb-0.4.0 */
#define HTS221_fields &HTS221_msg
#define LPS22HH_fields &LPS22HH_msg
#define Vector3D_fields &Vector3D_msg
#define IIS2MDCTR_fields &IIS2MDCTR_msg
#define ISM330DHCX_fields &ISM330DHCX_msg
#define UserButton_fields &UserButton_msg
#define Altitude_fields &Altitude_msg
#define Console_fields &Console_msg
#define Message_fields &Message_msg

/* Maximum encoded size of messages (where known) */
#define Altitude_size                            5
#define Console_size                             203
#define HTS221_size                              10
#define IIS2MDCTR_size                           17
#define ISM330DHCX_size                          34
#define LPS22HH_size                             10
#define Message_size                             206
#define PROTOCOL_PB_H_MAX_SIZE                   Message_size
#define UserButton_size                          2
#define Vector3D_size                            15

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
