% input
clear;
clc;
close all;
%
rep_courant=what;
rep_courant=rep_courant.path;
%
addpath (rep_courant);
addpath (genpath('/Users/fprunier/Documents/recherche/code_EF/code_matlab/ANA_2212b/sources'));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% il faut renumeroter si on excave et/ou ajoute des elements de structure
% externe au maillage du sol
% Attention il faut absolument ajouter une '*' en premier signe de tout
% 'physical_name' d'un element de poutre externe au maillage du sol
% fic_mail=gmsh_renum2(fic_mail);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% type de problme :
% axi = axi sym, defp = def plane
typ_sym='defp';
%
renum_mail=0; % si = 1 on utilise symrcm pour matrice bandes, sinon pas de renumrotation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% donne matriaux
Sol=cell(1,8);
%mat couche forme
rho=2.16e3;
E=120e6;
nu=0.25;
C0=1.e9;
C=1.e9; %100.e3; %0;
Bc=0.001;
phi0=5;
phif=35;
Bp=0.0002;
psif=5;
phie0=5;
phief=35;
psief=5;
epic=5.;
phires=40;
psires=10;
b=3.5;
itermaxi=100;
preci=1.e-6;
%
phi0=phi0*pi/180;
phif=phif*pi/180;
psif=psif*pi/180;
phie0=phie0*pi/180;
phief=phief*pi/180;
psief=psief*pi/180;
phires=phires*pi/180;
psires=psires*pi/180;
%
props=[rho,E,nu,C0,C,Bc,phi0,phif,Bp,psif,phie0,phief,psief,epic,phires,psires,b,itermaxi,preci];
% initialisation variables internes
varint0=0;
Mate{1}='PLR';
Mate{2}=props;
Mate{3}=varint0;
Sol{1,1}=Mate;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% maillage
fic_mail='fonda.msh';
fic_mail=[rep_courant,'/',fic_mail];
cellfich=gmsh_mail(fic_mail);
coord=gmsh_coord(cellfich);
% type d'lments et table connectivites
% Sol = elements fixes
% Struc = elements qui sont actives a chaque phase du calcul et assemble avec
% des multiplicateurs de Lagranges
Sol{1,2}={'tri6',[6,2,7]}; % typ element, nb no/elt,nddl/no, nb point integration
Sol{1,3}=gmsh_connec(cellfich,'"sol"'); % tab connec
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Phasage du calcul et CL
% nb d'tape = nnb de phase o les CL, voir le maillage peux changer
netap=2;
ETAP=cell(netap,6);
%%%%%%%%%%%%%%%%
%%%% etape 1
%%%%%%%%%%%%%%%%
chargement=-9.81;
% bord CL (U impos)
% remarque importante : on applique les incrments de deplacement
nbcl=2; % nb de bord avec cl, ou relation cin. impose
elem=gmsh_connec(cellfich,'"lat"');
no=gmsh_nod_el(elem);
CL{1,1}=no;
CL{1,2}=1;   % no du ddl du noeud sur le quel on impose un deplacment
CL{1,3}='Dimp';
CL{1,4}=ones(size(CL{1,1})); % rpartition spatiale de la valeur du dplacement sur chaque noeud
CL{1,5}=zeros(size(chargement)); % attention la rpartition temporelle doit avoir la mme taille pour chaque CL ou FL

elem=gmsh_connec(cellfich,'"bas"');
no=gmsh_nod_el(elem);
CL{2,1}=no;
CL{2,2}=2;
CL{2,3}='Dimp';
CL{2,4}=ones(size(CL{2,1}));
CL{2,5}=zeros(size(chargement));
% bord chargement (F impos)
% remarque importante : on applique les incrments de Force, contraintes...
nbfl=2; % nb de bord avec cl de type force, contrainte ou dep impose, ou application d'un force de volume
FL=cell(nbfl,6);
nbfcl=1; % nb de bord avec cl de type contrainte impose (pour construction des lments de bord).
FL{1,2}=[0,1]; % ddl sur le quel le chargement 1 agit (ici direction x) ( on peut mettre un vecteur de norme 1 pour dfinir un vecteur quelconque : par exemple normal  une surface incline)
FL{1,3}='Fvol'; % type d'action ici contrainte impose (mettre Fimp pour imposer les forces aux noeuds).
FL{1,5}=chargement; % volution temporelle du chargement 1

elem1=gmsh_connec(cellfich,'"haut"');
elem2=gmsh_connec(cellfich,'"hautlibre"');
elem=[elem2;elem1];
FL{2,1}=gmsh_nod_el(elem); % liste de noeuds chargement 1
FL{2,2}=[0,1]; % ddl sur le quel le chargement 1 agit (ici direction x) ( on peut mettre un vecteur de norme 1 pour dfinir un vecteur quelconque : par exemple normal  une surface incline)
FL{2,3}='Cimp';
FL{2,4}=ones(size(FL{2,1})); % volution spatiale du chargement 1 (nodal : valeur physique de la dep ou pression  la position des noeuds)
FL{2,5}=-2500; % volution temporelle du chargement 1
%
ETAP{1,1}=nbcl;
ETAP{1,2}=CL;
ETAP{1,3}=nbfl;
ETAP{1,4}=nbfcl;
ETAP{1,5}=FL;
%%%%%%%%%%%%%%%%
%%%% etape 2
%%%%%%%%%%%%%%%%
chargement=-250e3; %/25*ones(1,25);
% bord CL (U impos)
% remarque importante : on applique les incrments de deplacement
nbcl=2; % nb de bord avec cl, ou relation cin. impose
elem=gmsh_connec(cellfich,'"lat"');
no=gmsh_nod_el(elem);
CL{1,1}=no;
CL{1,2}=1;   % no du ddl du noeud sur le quel on impose un deplacment
CL{1,3}='Dimp';
CL{1,4}=ones(size(CL{1,1})); % rpartition spatiale de la valeur du dplacement sur chaque noeud
CL{1,5}=zeros(size(chargement)); % attention la rpartition temporelle doit avoir la mme taille pour chaque CL ou FL

elem=gmsh_connec(cellfich,'"bas"');
no=gmsh_nod_el(elem);
CL{2,1}=no;
CL{2,2}=2;
CL{2,3}='Dimp';
CL{2,4}=ones(size(CL{2,1}));
CL{2,5}=zeros(size(chargement));
% bord chargement (F impos)
% remarque importante : on applique les incrments de Force, contraintes...
nbfl=1; % nb de bord avec cl de type force, contrainte ou dep impose, ou application d'un force de volume
FL=cell(nbfl,6);
nbfcl=1; % nb de bord avec cl de type contrainte impose (pour construction des lments de bord).
elem=gmsh_connec(cellfich,'"haut"');
FL{1,1}=gmsh_nod_el(elem); % liste de noeuds chargement 1
FL{1,2}=[0,1]; % ddl sur le quel le chargement 1 agit (ici direction x) ( on peut mettre un vecteur de norme 1 pour dfinir un vecteur quelconque : par exemple normal  une surface incline)
FL{1,3}='Cimp';
FL{1,4}=ones(size(FL{1,1})); % volution spatiale du chargement 1 (nodal : valeur physique de la dep ou pression  la position des noeuds)
FL{1,5}=chargement; % volution temporelle du chargement 1
% %
ETAP{2,1}=nbcl;
ETAP{2,2}=CL;
ETAP{2,3}=nbfl;
ETAP{2,4}=nbfcl;
ETAP{2,5}=FL;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% precision globale
activOt=0;
prec=1.e-3;
itermax=800;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% appel du programme
principal;

save('postt');