% post traitement

% option af_mail=1 maillage, 2 maillage + no noeuds, 3 maillage + no elem,
% 4 maillage + no noeuds et no elem.
clear;
clc;
close all;
addpath (genpath('/Users/fprunier/Desktop/fonda'));
load('postt.mat');

af_mail=1;

if isempty(Usoltot{end})==0
    pasres=size(Usoltot,1); %size(Usoltot,2)-9; %size(Usoltot,2)
else
    test=0;
    compt=0;
    while test==0
        compt=compt+1;
        test=isempty(Usoltot{compt});
    end
    pasres=compt-1;
end

%pasres=27;

nb_zone=1;

res=[];
connec=[];
nel=0;

Ut=Usoltot{pasres};
nddl=0;
for izone=1:nb_zone
    A=Sol{izone,3};
    Amax=max(max(A));
    nddl=max(Amax,nddl);
end
nddl=nddl*2;
coord=coord(1:nddl/2,:);

connectot=[];
neltot=0;
for izone=1:nb_zone
    connec=Sol{izone,3};
    typ_el=Sol{izone,2}{1};
    carel=Sol{izone,2}{2};
    nel=size(connec,1);
    
    Ut0=Usoltot{2}; %Usoltot{2};  %zeros(size(Ut));
    Ut0=Ut0(1:nddl);
    Ux0=Ut0(1:2:nddl-1);
    Uy0=Ut0(2:2:nddl);
    XY0=coord+[Ux0,Uy0];
    
    %nddl=size(coord,1)*Carel{izone}(2);
    Ux=Ut(1:2:nddl-1);
    Uy=Ut(2:2:nddl);
    XY=coord+[Ux0,Uy0]+[Ux-Ux0,Uy-Uy0]*30;
    
    if af_mail~=0
        affich_mail(XY0,af_mail,'blue',Sol{izone,3},Sol{izone,2}{1},1);
        affich_mail(XY,af_mail,'red',Sol{izone,3},Sol{izone,2}{1},1);
    end

    Ut0=Usoltot{1};
    Ut0=Ut0(1:nddl);
    %Ux0=Ut0(1:2:nddl-1);
    Uy0=Ut0(2:2:nddl);
        
    SIG=Sol{izone,6}{pasres};
    EPS=Sol{izone,5}{pasres};
    VARINT=Sol{izone,7}{pasres};
%    W2n=Sol{izone,8}{pasres};
    
    res1=interp_nod(SIG,[coord(:,1),coord(:,2)],nel,typ_el,carel,connec);
    res2=interp_nod(EPS,[coord(:,1),coord(:,2)],nel,typ_el,carel,connec);
    res3=interp_nod(VARINT,[coord(:,1),coord(:,2)],nel,typ_el,carel,connec);
%    res4=interp_nod(W2n,[coord(:,1),coord(:,2)],nel,typ_el,carel,connec);
    
    phif=Sol{izone,1}{1,2}(8); %40*pi/180; %Mate{izone,2}(6);
    C=Sol{izone,1}{1,2}(4);  %1.e3; %Mate{izone,2}(4);
    m=2*sin(phif)/(sqrt(3)*(3-sin(phif)));
    k=6*C*cos(phif)/(sqrt(3)*(3-sin(phif)));
    res5=[m*ones(size(res1,1),1),k*ones(size(res1,1),1)];
    
    res=[res;res1,res2(:,3:end),res3(:,3:end),res5]; %,res4(:,3:end)]; %,res5];

    connectot=[connectot;connec];
    neltot=neltot+nel;
end

figure(1)
title('dforme x30')

res2=NaN([size(XY,1),size(res,2)]);
for k2=1:size(res,1)
    for k1=1:size(coord,1)
        if coord(k1,1)==res(k2,1) && coord(k1,2)==res(k2,2)
            res2(k1,:)=res(k2,:);
        end
    end
end

X=res2(:,1);
Y=res2(:,2);
sxx=-res2(:,3)*1.e-3;
syy=-res2(:,5)*1.e-3;
exx=-res2(:,7)*100;
eyy=-res2(:,9)*100;
epeq=res2(:,11)*100;
% w2n=res2(:,13);

sig=res2(:,3:6);
sig(:,4)=sqrt(2)*sig(:,4);
I1=sum(sig(:,1:3),2);
devsig=sig(:,1:3)-I1/3;
devsig=[devsig,sig(:,4)];
J2=sqrt(1/2*sum(devsig.*devsig,2));
m=res2(:,13);
k=res2(:,14);
J2max=k-m.*I1;
% x=find(f>0);
% f(x)=0;
taurel=J2./J2max;

figure(2)
hold on
p = patch('Faces',connectot(:,1:3),'Vertices',coord,'FaceVertexCData',(Uy0-Uy)*1000);
p.FaceColor = 'interp';
% p.EdgeColor = ' none';
% p=contourTri(connectot(:,1:3),coord(:,1),coord(:,2),(Uy0-Uy)*1000,15);
% p.EdgeColor='black';
% p.LineWidth=1;
% p.ShowText='on';
p=colorbar;
p.Label.String = 'Uy (mm)';
colormap 'jet';
axis equal;
%shading 'interp';


figure(3)
hold on
p = patch('Faces',connectot(:,1:3),'Vertices',coord,'FaceVertexCData',syy);
p.FaceColor = 'interp';
% p.EdgeColor = ' none';
% p=contourTri(connectot(:,1:3),coord(:,1),coord(:,2),syy,15);
% p.EdgeColor='black';
% p.LineWidth=1;
% p.ShowText='on';
p=colorbar;
p.Label.String = '\sigma_{yy} (kP_a)';
colormap 'jet';
axis equal;
%shading 'interp';

% figure(4)
% hold on
% p = patch('Faces',connectot(:,1:3),'Vertices',coord,'FaceVertexCData',taurel);
% p.FaceColor = 'interp';
% % p.EdgeColor = ' none';
% % p=contourTri(connectot(:,1:3),coord(:,1),coord(:,2),taurel,15);
% % p.EdgeColor='black';
% % p.LineWidth=1;
% % p.ShowText='on';
% % clim([0. 1.]);
% p=colorbar;
% p.Label.String = '\tau_{rel}';
% colormap 'jet';
% axis equal;
% %shading 'interp';

% figure(5)
% hold on
% p = patch('Faces',connectot(:,1:3),'Vertices',coord,'FaceVertexCData',epeq);
% p.FaceColor = 'interp';
% % p.EdgeColor = ' none';
% % p=contourTri(connectot(:,1:3),coord(:,1),coord(:,2),epeq,15);
% % p.EdgeColor='black';
% % p.LineWidth=1;
% % p.ShowText='on';
% p=colorbar;
% p.Label.String = '\epsilon^p_{eq}';
% colormap 'jet';
% axis equal;