% main 2D
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% structure des tableaux Sol et Struc
%%% SOl
% 1    2      3      4      5   6   7      8             9
% Mate typ_el connec numnod Eps Sig Varint [w2n,w2,nw2]  coord_PI
%%% Struc
% 1    2      3      4      5   6   7      8            9  10 11
% Mate typ_el connec numnod Eps Sig Varint [w2n,w2,nw2] Kt U  F
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% commentaires : dans Struc mettre dans Eps et Sig, les efforts internes
% pour visualiser volution N,T,Mf et eps_xx, gamma_xy?

% revoir l'initialisation de Ksoltot et Kt des structures:
% ide: si pas matrice tangente, on garde uniquement indice initial une
% fois pour toute (sauf Ksol qui peut tre mis  jours aprs excavation,
% mais on garde dans indice initial
% sinon tableau Ksoltot et Kt avec 3 indices : K0, Kt-1, et Kt pour procedure de convergence "forcee"
% Attention a chaque fois qu'on a excav il fautr mettre a jour K0.



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% renumerotation et agencement des donnees
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nb_sol=size(Sol,1);
if nb_sol>1 
    nod_sol=[];
end
for ii=1:nb_sol
    connec=Sol{ii,3};
    nod=reshape(connec,[],1);
    nod=sort(nod);
    nod2sup=[];
    for jj=2:max(size(nod))
        if nod(jj)==nod(jj-1)
            nod2sup=[nod2sup;jj];
        end
    end
    nod(nod2sup)=[];
    if nb_sol>1 
        nod_sol=[nod_sol;nod];
    end
    Sol{ii,4}=nod;
end
if nb_sol>1 
    nod_sol=sort(nod_sol);
    nod2sup=[];
    for jj=2:max(size(nod_sol))
        if nod_sol(jj)==nod_sol(jj-1)
            nod2sup=[nod2sup;jj];
        end
    end
    nod_sol(nod2sup)=[];
else
    nod_sol=nod;
end
nb_no_sol=size(nod_sol,1);
%
if exist('Struc','var')==1
    nb_struc=size(Struc,1);
    for ii=1:nb_struc
        connec=Struc{ii,3};
        nod=reshape(connec,[],1);
        nod=sort(nod);
        nod2sup=[];
        for jj=2:max(size(nod))
            if nod(jj)==nod(jj-1)
                nod2sup=[nod2sup;jj];
            end
        end
        nod(nod2sup)=[];
        Struc{ii,4}=nod;
    end
else
    nb_struc=0;
end
%
nddl_sol=nb_no_sol*2; %  c'est le nb de ddl 2d sans les ddl de structure/poutre
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% nb de pas de calculs: npas*netpas + 1 (pas 1 = pas initial)
npastot=1;
for jj=1:netap
    npastot=npastot+size(ETAP{jj,2}{1,5},2);
end
%
% construction des matrices de rigidites des poutres et initialisation
% des tables Ustruc et Festruc
for istruc=1:nb_struc
    typ_struc=Struc{istruc,2}{1};
    switch typ_struc
        case 'poutre'
            props=Struc{istruc,1}{2};
            carel=Struc{istruc,2}{2};
            connec=Struc{istruc,3};
            nel=size(connec,1);
            Struc{istruc,9}=Ktotpoutre(coord,connec,nel,carel,props,max(size(coord)));
        case '2D'
            Struc{istruc,:}=KSTRU0(Struc{istruc,:});
    end
    nddl_stru=size(Struc{istruc,9},1);
    Struc{istruc,10}=cell(npastot,1); % Ustruc
    Struc{istruc,11}=cell(npastot,1); % Festruc
    Struc{istruc,10}{1}=zeros(nddl_stru,1); % initialisation pas 1
    Struc{istruc,11}{1}=zeros(nddl_stru,1); % initialisation pas 1
end
%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%
% construction de la matrice de rigidite du sol et initialisation des
% tables Eps, Sig, varint
[Ksol,Sol,typ_elsurf,carelsurf,ntens]=SOL_ini(Sol,coord,nb_sol,nddl_sol,typ_sym,npastot);
Usoltot=cell(npastot,1);
Usoltot{1}=zeros(nddl_sol,1);
Fisoltot=cell(npastot,1);
Fisoltot{1}=zeros(nddl_sol,1);
Ksoltot=cell(2,1); % on stoke Ktgt en 1 et K0 en 2 pour pb de divergences
Ksoltot{1}=Ksol;
Ksoltot{2}=Ksol;
W2Ntot=zeros(npastot,1);%global
W2tot=zeros(npastot,1);%global
% boucle sur le nombre d'etapes
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% initialisation de la boucle de Newton
coord_sol=coord(1:nb_no_sol,:);
%
compt=1; % pas 1 =  pas initial
pas_iter=[];
tic;
for ietap=1:netap % = nb de phasage : chgt de condition limite accept entre deux "phases"
    disp(['phase ',num2str(ietap)]);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % reconstruction de Ksol, Usol, Fesol, etc... si excavation
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %FL=ETAP{ietap,5};
    nbfl=ETAP{ietap,3};
    for icl=1:nbfl
        typ_cl=ETAP{ietap,5}{icl,3};
        if strcmp(typ_cl,'Excav')==1
            typ_el=Sol{nb_sol,2}{1};
            connec=Sol{nb_sol,3};
            nel=max(size(connec));
            carel=Sol{nb_sol,2}{2};
            Sig=Sol{nb_sol,6}{compt};
            Mate=Sol{nb_sol,1};
            Varint=Sol{nb_sol,7}{compt};
            REAC_bord_excav=Reac_bord(nddl_sol,nod_ddl,FL,icl,typ_el,typ_sym,coord,connec,nel,carel,ntens,Sig,Mate,Varint);
            %
            ddl2sup=DDL2sup(connec,FL{icl,1});
            %
            nddl_sol=nddl_sol-max(size(ddl2sup));
            nb_no_sol=nddl_sol/2;
            nb_sol=nb_sol-1;
            ETAP{ietap,5}{icl,3}='Reac_bord';
            ETAP{ietap,5}{icl,4}=REAC_bord_excav(1:nddl_sol);
            %ETAP{ietap,5}=FL;
            % recalcul de Ksol car termes en trop sur les ddl
            % concomittants a la zone escavee
            Ksol=zeros(nddl_sol,nddl_sol);
            if activOt==1
                Ksol0=Ksol;
            end
            for isol=1:nb_sol
                typ_el=Sol{isol,2}{1};
                carel=Sol{isol,2}{2};
                connec=Sol{isol,3};
                nel=max(size(connec));
                Sig=Sol{isol,6}{compt};
                varint=Sol{isol,7}{compt};
                C=Cintg(nel,carel,ntens,Sig,Mate,varint,activOt);
                Ksol=Ktot(coord,connec,C,nel,typ_el,carel,Ksol,typ_sym);
                if activOt==1
                    C0=Cintg(nel,carel,ntens,Sig,Mate,varint,0);
                    Ksol0=Ktot(coord,connec,C0,nel,typ_el,carel,Ksol,typ_sym);
                end
            end
            % Ksol=sparse(Ksol);
            Ksoltot{1}=Ksol;
            if activOt==1
                % Ksol0=sparse(Ksol0);
                Ksoltot{2}=Ksol0;
            else
                Ksoltot{2}=Ksol;
            end
            %Sol=Sol(1:nb_sol-1,:);
            coord_sol=coord_sol(1:nb_no_sol,:);
        elseif strcmp(typ_cl,'Reac')==1             
            REAC_bord=zeros(size(Fit));
            no_bord_excav=ETAP{ietap,5}{icl,1}; %FL{icl,1};
            ddlimp=zeros(size(no_bord_excav,1)*2,1);
            ddlimp(2:2:end)=2*no_bord_excav;
            ddlimp(1:2:end-1)=2*no_bord_excav-1;
            REAC_bord(ddlimp)=Fit(ddlimp);
            ETAP{ietap,5}{icl,3}='Reac_bord';
            ETAP{ietap,5}{icl,4}=-REAC_bord;
            %ETAP{ietap,5}=FL;
        end
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % construction de la matrice de rigidite avec ces CL et rela cin
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    nbcl=ETAP{ietap,1};
    nbfl=ETAP{ietap,3};
    nbfcl=ETAP{ietap,4};
    %CL=ETAP{ietap,2};
    %FL=ETAP{ietap,5};
    %zone_active=ETAP{ietap,6};
    if isempty(ETAP{ietap,6})
        Kt=Ksoltot{1};
        coord_phase=coord_sol;
        %nod_ddl = table de numero des noeuds avec le numero de ses ddl associes
        %dans la matrice globale (pratique uniquement quand on couple des
        %elements avec un nb de ddl par noeuds differents)
        nod_ddl=zeros(nb_no_sol,3);
        nod_ddl(:,1)=(1:2:2*nb_no_sol-1)';
        nod_ddl(:,2)=(2:2:2*nb_no_sol)';
        nddl_tot=nddl_sol;
        [ddlimp,ddlrela,B]=ajout_CL(nbcl,ETAP{ietap,2},nod_ddl,nddl_tot);
    else % ajout elements poutres s'il y'en a
        [coord_phase,ETAP(ietap,:),nod_ddl]=renum_struct(nb_no_sol,coord,coord_sol,Struc,ETAP(ietap,:));
        nddl_tot=max(max(nod_ddl));
        %zone_active=ETAP{ietap,6};
        Kt=ajout_struc(ETAP{ietap,6},Ksoltot{1},Struc); % matrice rigidite augmentee
        [ddlimp,ddlrela,B]=ajout_CL(nbcl,ETAP{ietap,2},nod_ddl,nddl_tot); % CL
        [ddlrela,B]=attach_struc(ETAP{ietap,6},nod_ddl,ddlrela,B); % accrochage structure
    end
%    B(:,ddlrela)=[];
    ddllib=(1:max(max(nod_ddl)))';
    ddllib([ddlimp;ddlrela])=[];
    % construction des lments de bord pour les contraintes imposes
    if nbfcl>0
        %connecfcl=cell(nbfcl,1);
        for ifcl =1:nbfl %nbfcl
            type_bord=ETAP{ietap,5}{ifcl,3};
            if (strcmp(type_bord,'Cimp')==1 && isempty(ETAP{ietap,5}{ifcl,6})==1)
                %liste des connexions des lments pour calcul force de surface
                ETAP{ietap,5}{ifcl,6}=elem_bord(ETAP{ietap,5}{ifcl,1},typ_elsurf); %elem_bord(coord_phase,ETAP{ietap,5}{ifcl,1},typ_elsurf);
            end
        end
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % nb de pas de calcul dans une mme phase
    CL=ETAP{ietap,2};
    FL=ETAP{ietap,5};
    zone_active=ETAP{ietap,6};

    npas=size(CL{1,5},2);
    for ipas=1:npas
        DFet=zeros(nddl_tot,1);
        compt=compt+1;
%        disp(['etap ',num2str(compt-1)]);
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % deplacemements aux limites
        DUimp=ajout_Uimp(nbcl,CL,nod_ddl,nddl_tot,ipas);
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %chargements aux limites
        for icl=1:nbfl
            typ_cl=FL{icl,3};
            switch typ_cl
                case 'Fvol'
                    % force de volume
                    a=FL{icl,2}*FL{icl,5}(ipas);
                    a=a';
                    Fv=zeros(size(DFet));
                    for isol=1:nb_sol
                        rho=Sol{isol,1}{2}(1);
                        connec=Sol{isol,3};
                        nel=size(connec,1);
                        typ_el=Sol{isol,2}{1};
                        carel=Sol{isol,2}{2};
                        Fv=Fvol(coord_phase,connec,rho,a,nel,typ_el,carel,typ_sym,Fv);
                    end
                    DFet=DFet+Fv;
                    % ajouter calcul de Fv pour les Struc
                case 'Cimp'
                    % force ext de surface
                    sigsurf=FL{icl,4}*FL{icl,5}(ipas); % en norme : valeur physique de la contrainte applique  la position des noeuds
                    if max(size(FL{icl,2}))==2
                        sigsurf=sigsurf*FL{icl,2}; % en composante
                        Fs=Fsurf(coord_phase,nod_ddl,FL{icl,1},FL{icl,6},sigsurf,typ_elsurf,carelsurf,typ_sym,size(DFet,1));
                    else % composantes sur la facette normale: partie reelle : normale, partie imaginaire : tangentielle
                        normal_noeud=Normal_noeud(coord_phase,FL{icl,1},FL{icl,6});
                        sigsurf=[sigsurf sigsurf];
                        sigsurf=sigsurf.*normal_noeud;
                        Fs=Fsurf(coord_phase,nod_ddl,FL{icl,1},FL{icl,6},sigsurf,typ_elsurf,carelsurf,typ_sym,size(DFet,1));
                    end
                    DFet=DFet+Fs;
                    %  modifier si contrainte applique sur une poutre de
                    % fondation par exemple
                case 'Fimp'
                    % force nodale
                    Fp=Fnod(size(DFet,1),nod_ddl,FL,icl,ipas);
                    %
                    DFet=DFet+Fp;
                case 'Reac_bord'
                    % on met dans FL{icl,4} le vecteur REAC_NOD a amplifier
                    DFet=DFet+FL{icl,4}*FL{icl,5}(ipas);
            end
        end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % calcul
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % initialisation pour itration : tir elastique initial
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        Ut=zeros(nddl_tot,1);

%         DUt=Ut;
%         DUcl=zeros(size(ddllib));


        Ut(1:nddl_sol)=Usoltot{compt-1}(1:nddl_sol);
        Fit0=zeros(nddl_tot,1);
        Fit0(1:nddl_sol)=Fisoltot{compt-1}(1:nddl_sol);
        if activOt==1
            Kt(1:nddl_sol,1:nddl_sol)=Ksoltot{1};
        end

        if ipas==1 % si on debute l'tape, sinon on part avec l'itr prcdent.
            if any(ddlrela)
                DFet=B'*DFet;
                Kt=B'*Kt*B;
            end
            DUt=DUimp;
            DFecl=DFet;
            for ii=1:size(ddlimp,1)
                DFecl=DFecl-Kt(:,ddlimp(ii))*DUt(ddlimp(ii));
            end
            %if ipas==1
                Kt1=inv(Kt(ddllib,ddllib));
            %end
            %DUcl=Kt(ddllib,ddllib)\DFecl(ddllib);
            DUcl=Kt1*DFecl(ddllib);
            DUt(ddllib)=DUcl;
            if any(ddlrela)
                DUt=B*DUt;
            end
        end
        
        %nb_zone_sol=size(Sol,1);
        Fit=zeros(nddl_tot,1);
        for isol=1:nb_sol
            typ_el=Sol{isol,2}{1};
            carel=Sol{isol,2}{2};
            connec=Sol{isol,3};
            nel=size(connec,1);
            Mate=Sol{isol,1};
            Eps=Sol{isol,5}{compt-1};
            Sig=Sol{isol,6}{compt-1};
            varint=Sol{isol,7}{compt-1};
            [Fit,DEps,Sol{isol,6}{compt},Sol{isol,7}{compt},convergence]=Fintg(typ_el,typ_sym,coord_phase,connec,nod_ddl,nel,carel,ntens,DUt(1:nddl_sol),Sig,Mate,varint,Fit);
            Sol{isol,5}{compt}=Eps+DEps;
        end

        if nb_struc>0
            iligne=nddl_sol;
            for istruc=1:size(zone_active,1)
                materiau=Struc{istruc,1}{1};
                K=Struc{istruc,9};
                nddl_struc=size(K,1);
                jligne=iligne+nddl_struc;
                DUstruc=DUt(iligne+1:jligne);
                if (strcmp(materiau,'HOOK')==1 || strcmp(materiau,'POUTRE_2DEL')==1)
                    Ustruc=Struc{istruc,10}{compt-1}+DUstruc;
                    Fit(iligne+1:jligne)=K*Ustruc;
                else
                    typ_el=Struc{istruc,2}{1};
                    carel=Struc{istruc,2}{2};
                    connec=Struc{istruc,3};
                    nel=max(size(connec));
                    Mate=Struc{istruc,1};
                    Eps=Struc{istruc,5}{compt-1};
                    Sig=Struc{istruc,6}{compt-1};
                    varint=Struc{istruc,7}{compt-1};
                    [Fit,DEps,Struc{istruc,6}{compt},Struc{istruc,7}{compt},convergence]=Fintg(typ_el,typ_sym,coord_phase,connec,nod_ddl,nel,carel,ntens,DUstruc,Sig,Mate,varint,Fit);
                    Struc{istruc,5}{compt}=Eps+DEps;
                end
                iligne=jligne;
            end
        end

        if any(ddlrela)
            DFit=B'*(Fit-Fit0);
        else
            DFit=Fit-Fit0;
        end
        Res=DFit(ddllib)-DFet(ddllib);
        %crit=abs(Res'*DUt(ddllib));
        crit=max(abs(Res)/max(abs(DFit)));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % boucle de Newton
        knewton=0;
        if crit>prec
            Kcl=Kt(ddllib,ddllib);
            dDUt=zeros(nddl_tot,1);
        end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        while (crit>prec && knewton<itermax)
            knewton=knewton+1;
            if (renum_mail==1)
                perm=symrcm(Kcl);
                Kclp=Kcl(perm,perm);
                Resp=Res(perm);
                dDUclp=-Kclp\Resp;
                [~,perminv]=sort(perm);
                dDUcl=dDUclp(perminv);
            else
                %dDUcl=-Kcl\Res;
                dDUcl=-Kt1*Res;
            end
            DUcl=DUcl+dDUcl;

            dDUt(ddllib)=dDUcl;
            if any(ddlrela)
                dDUt=B*dDUt;
            end
            DUt=DUt+dDUt; % ajout 8/04/2022

            Fit=zeros(nddl_tot,1);
            for isol=1:nb_sol
                typ_el=Sol{isol,2}{1};
                carel=Sol{isol,2}{2};
                connec=Sol{isol,3};
                nel=size(connec,1);
                Mate=Sol{isol,1};
                Sig=Sol{isol,6}{compt};
                varint=Sol{isol,7}{compt};
                [Fit,DEps,Sol{isol,6}{compt},Sol{isol,7}{compt},convergence]=Fintg(typ_el,typ_sym,coord_phase,connec,nod_ddl,nel,carel,ntens,dDUt(1:nddl_sol),Sig,Mate,varint,Fit);
                Sol{isol,5}{compt}=Sol{isol,5}{compt}+DEps;
            end
            if nb_struc>0
                iligne=nddl_sol;
                for istruc=1:size(zone_active,1)
                    materiau=Struc{istruc,1}{1};
                    K=Struc{istruc,9};
                    nddl_struc=size(K,1);
                    jligne=iligne+nddl_struc;
                    if (strcmp(materiau,'HOOK')==1 || strcmp(materiau,'POUTRE_2DEL')==1)
                        DUstruc=DUt(iligne+1:jligne);
                        Ustruc=Struc{istruc,10}{compt-1}+DUstruc;
                        Fit(iligne+1:jligne)=K*Ustruc;
                    else
                        dDUstruc=dDUt(iligne+1:jligne);
                        typ_el=Struc{istruc,2}{1};
                        carel=Struc{istruc,2}{2};
                        connec=Struc{istruc,3};
                        nel=max(size(connec));
                        Mate=Struc{istruc,1};
                        Sig=Struc{istruc,6}{compt};
                        varint=Struc{istruc,7}{compt};
                        [Fit,DEps,Struc{istruc,6}{compt},Struc{istruc,7}{compt},convergence]=Fintg(typ_el,typ_sym,coord_phase,connec,nel,carel,ntens,dDUstruc,Sig,Mate,varint,Fit);
                        Struc{istruc,5}{compt}=Struc{istruc,5}{compt}+DEps;
                    end
                    iligne=jligne;
                end
            end

            if any(ddlrela)
                DFit=B'*(Fit-Fit0);
            else
                DFit=Fit-Fit0;
            end
            Res=DFit(ddllib)-DFet(ddllib);
            %crit=abs(Res'*DUt(ddllib));
            crit=max(abs(Res)/max(abs(DFit)));
        end
%         if knewton > 0
%             DUt=DUimp;
%             DUt(ddllib)=DUr;  % modif 8/04/2022
%         end
        Ut=Ut+DUt;
        Usoltot{compt}=Ut(1:nddl_sol);
        Fisoltot{compt}=Fit(1:nddl_sol);
        if nb_struc>0
            iligne=nddl_sol;
            for istruc=1:size(zone_active,1)
                nddl_struc=size(K,1);
                jligne=iligne+nddl_struc;
                Ustruc=Ut(iligne+1:jligne);
                Fistruc=Fit(iligne+1:jligne);
                Struc{istruc,10}{compt}=Ustruc;
                Struc{istruc,11}{compt}=Fistruc;
            end
        end
        pas_iter=[pas_iter;ietap,compt,knewton];
        %
        W2=0;
        NW2=0;
        for isol=1:nb_sol
            if compt >1
                DSig=Sol{isol,6}{compt}-Sol{isol,6}{compt-1};
                DEps=Sol{isol,5}{compt}-Sol{isol,5}{compt-1};
            else
                DSig=Sol{isol,6}{compt};
                DEps=Sol{isol,5}{compt};
            end
            if ntens==4
                DSig(4,:,:)=sqrt(2)*DSig(4,:,:);
                DEps(4,:,:)=sqrt(2)/2*DEps(4,:,:); % car gammaij et non eij
                nw2=sqrt(sum(DSig.*DSig)).*sqrt(sum(DEps.*DEps));
                w2=sum(DSig.*DEps);
            elseif ntens==3
                DSig(4:6,:,:)=sqrt(2)*DSig(4:6,:,:);
                DEps(3,:,:)=sqrt(2)/2*DEps(3,:,:); % car gammaij et non eij
                nw2=sqrt(sum(DSig.*DSig)).*sqrt(sum(DEps.*DEps));
                DSig([3,5,6],:,:)=[];
                w2=sum(DSig.*DEps);
            end
            Sol{isol,8}{compt}=[w2./nw2;w2;nw2]; % travail du second ordre local

            typ_el=Sol{isol,2}{1};
            carel=Sol{isol,2}{2};
            connec=Sol{isol,3};
            nel=size(connec,1);
            intw2=Wintg(typ_el,typ_sym,coord_sol,connec,nel,carel,w2);
            intnw2=Wintg(typ_el,typ_sym,coord_sol,connec,nel,carel,nw2);
            W2=W2+intw2;
            NW2=NW2+intnw2;
        end
        W2Ntot(compt)=W2/NW2; %travail du second ordre global
        W2tot(compt)=W2; %travail du second ordre global
        % mise  jour de Ustruc et Fstruc
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% matrices tangentes :
% on itre avec Ktgt actualis  chaque nouveau pas (pas chaque itration)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        if (activOt ==1)
            Ksol=zeros(nddl_sol,nddl_sol);
            for izone=1:nb_sol
                connec=Sol{izone,3};
                nel=size(connec,1);
                carel=Sol{izone,2}{2};
                typ_el=Sol{izone,2}{1};
                Sig=Sol{izone,6}{compt};
                Mate=Sol{izone,1};
                Varint=Sol{izone,7}{compt};
                C=Cintg(nel,carel,ntens,Sig,Mate,Varint,activOt);
                Ksol=Ktot(coord_sol,connec,C,nel,typ_el,carel,Ksol,typ_sym);
            end
            % Ksol=sparse(Ksol);
            Ksoltot{1}=Ksol;
            %
            if isempty(zone_active)==0
                nb_zone=size(zone_active,1);
                num_ddl_0=nddl_sol;
                for izone=1:nb_zone
                    Kstruc=Struc{zone,9}{1}*0;
                    zone=zone_active{izone,1};
                    Mate=Struc{zone,1}{1};
                    loi_non_lin =contains('DPB DPH PLR',Mate);
                    if loi_non_lin==1
                        connec=Struc{zone,3};
                        nel=size(connec,1);
                        carel=Struc{zone,2}{2};
                        typ_el=Struc{zone,2}{1};
                        Sig=Struc{zone,6}{compt};
                        Varint=Struc{zone,7};
                        C=Cintg(nel,carel,ntens,Sig,Mate,Varint,activOt);
                        Kstruc=Ktot(coord_phase,connec,C,nel,typ_el,carel,Kstruc,typ_sym);
                        % Kstruc=sparse(Kstruc);
                        Struc{zone,9}{1}=Kstruc;
                    end
                end
            end
        end

        if (knewton==itermax)
            break;
        end
        disp([ipas, knewton]);
    end % fin boucle pas
    if (knewton==itermax) % || norm(convergence(:,3))>0)
        disp('compt=');
        disp(compt);
        disp('knewton=');
        disp(knewton);
        break;
    end
end %fin boucle etapes
toc;