function sig=sig_eps(eps,props)

nc=size(props,2);
switch nc
    case 2
        % loi de Hook
        E=props(1);
        nu=props(2);
        Mo=E/((1+nu)*(1-2*nu))*[1-nu nu nu 0 0 0;...
            nu 1-nu nu 0 0 0;...
            nu nu 1-nu 0 0 0;...
            0 0 0 (1-2*nu) 0 0;...
            0 0 0 0 (1-2*nu) 0;...
            0 0 0 0 0 (1-2*nu)];
        sig=Mo*eps;     
        
    case 4
        % modele houlsby
        %eps=-eps;
        
        E=props(1);
        nu=props(2);
        po=props(3);  % pression relative  l'atmosphre (ingnieurs)
        n=props(4);
        
        k=E/(3*(1-2*nu)*po);
        g=E/(2*(1+nu)*po);
        
        % valeurs drives
        A=po/(k*(2-n))*((1-n)*k)^((2-n)/(1-n));
        d=3*g/(k*(1-n));
        % invariants des tenseurs
        I=[1;1;1;0;0;0];
        %Ir2=[1;1;1;sqrt(2);sqrt(2);sqrt(2)];
        ev=sum(eps(1:3));
        %deve=e.*Ir2-ev/3.*I;
        deve=eps-ev/3*I;
        es=sqrt(2/3)*sqrt(deve'*deve);
        %
        F=ev^2+d*es^2;
        G1=ev+2*d/3*(2/3*eps(1)-1/3*(eps(2)+eps(3))); % dF/de11
        G2=ev+2*d/3*(2/3*eps(2)-1/3*(eps(1)+eps(3))); % dF/de22
        G3=ev+2*d/3*(2/3*eps(3)-1/3*(eps(2)+eps(1))); % dF/de33
        G=[G1;G2;G3];
        H=eps(4:6)*2*d/3 ;       % dF/deij i/=j
        % calcul des contraintes
        sig=A*(2-n)/(1-n)*F^(n/(2-2*n))*[G;H];
        %sig=-sig;

end