function Jac=PLRJac(s,ep,Dlambda,C,phi0,phif,psif,Bp,Mo)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Jac analytique
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
phi=phi0+(phif-phi0)*ep/(Bp+ep);
psi=phi-(phif-psif);

Is=s(1)+s(2)+s(3);
devsig=s-Is/3*[1;1;1;0;0;0];
IIs=sqrt(0.5*(devsig'*devsig));

gtilde=DPBgtilde(s,psi);
A2=Mo*gtilde;

val=sqrt(3)/3;
Jac = zeros(8,8);
% premier terme drsig/dsig (dim = 6*6) : le plus compliqu
% drsig/dsig = I66 + dlambda*Mo*d/dsig(dg/dsig) =
% drsig1+dlambda*Mo*drsig2;
% dans notre cas particulier, d/dsig(dg/dsig)=d(Sij/(2*IIs))/dsig
% calcul de ce dernier terme (dim = 6*6)
drsig2=zeros(6,6);
for ii=1:3
    for jj=1:3
        if ii==jj
            drsig2(ii,jj)=1/(3*IIs)*(1-devsig(ii)^2/(2*IIs^2)); %terme diag sup
            drsig2(ii+3,jj+3)=1/(2*IIs)-(devsig(ii+3)/sqrt(2))^2/(4*IIs^3); % terme diag inf
        else
            drsig2(ii,jj)=-1/(6*IIs)*(1+devsig(ii)*devsig(jj)/(IIs^2)); % terme hors diag carre (1:3,1:3)
            drsig2(ii+3,jj+3)=-1/(4*IIs^3)*devsig(ii+3)/sqrt(2)*devsig(jj+3)/sqrt(2); % terme hors diag carre (4:6,4:6)
        end
        drsig2(ii,jj+3)=-1/(4*IIs^3)*(devsig(ii)*devsig(jj+3)/sqrt(2)); % terme hors diag carre (1:3,4:6)
        drsig2(ii+3,jj)=-1/(6*IIs^3)*devsig(ii+3)/sqrt(2)*devsig(jj); % terme hors diag carre (4:6,1:3)
    end
end
%
drsigdsig=eye(6)+Dlambda*Mo*drsig2;
Jac(1:6,1:6)=drsigdsig;
% second terme drsig/dep (dim = 6*1)
% drsig/dep=dlambda*Mo*dm'/dep*I61
% dm'/dep=dm'/dpsi*dpsi/dep
dmdpsi=2*sqrt(3)*cos(psi)/(3-sin(psi))^2;
dpsidep=(phif-phi0)*Bp/(Bp+ep)^2;
drsigdep=Dlambda*dmdpsi*dpsidep*Mo*[1;1;1;0;0;0];
Jac(1:6,7)=drsigdep;
% troisieme terme drsig/dlambda (dim = 6*1)
% drsig/dlambda=Mo*dgdsig=A2
Jac(1:6,8)=A2;
% quatrime terme drep/dsig=0 (dim = 1*6)
% cinqime terme drep/drep=1 (dim = 1*1)
Jac(7,7)=1;
% sixime terme drep/dlambda = -val
Jac(7,8)=-val;
% septime terme drf/dsig = dfdsig
m=2*sin(phi)/(sqrt(3)*(3-sin(phi)));
dfdsig=m*[1;1;1;0;0;0]+devsig/(2*IIs);
Jac(8,1:6)=dfdsig;
% huitime terme drf/dep = dfdphi*dphidep
dfdphi=2*Is/sqrt(3)*(cos(phi)/(3-sin(phi))+cos(phi)*sin(phi)/(3-sin(phi))^2)-6*C/sqrt(3)*(sin(phi)/(3-sin(phi))+cos(phi)^2/(3-sin(phi))^2);
dphidep=(phif-phi0)/(Bp+ep)-ep*(phif-phi0)/(Bp+ep)^2;
Jac(8,7)=dfdphi*dphidep;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Jac numrique
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% h=1.e-6;
%
% phi=phi0+(phif-phi0)*ep/(Bp+ep);
% psi=phi-(phif-psif);
% Is=s(1)+s(2)+s(3);
% devsig=s-Is/3*[1;1;1;0;0;0];
% IIs=sqrt(0.5*(devsig'*devsig));
% 
% val=sqrt(3)/3;
% 
% Jac = zeros(8,8);
% % premier terme drsig/dsig (dim = 6*6) : le plus compliqu
% % drsig/dsig = I66 + dlambda*Mo*d/dsig(dg/dsig) =
% % drsig1+dlambda*Mo*drsig2;
% % dans notre cas particulier, d/dsig(dg/dsig)=d(Sij/(2*IIs))/dsig
% % calcul de ce dernier terme (dim = 6*6)
% dgtildeds=zeros(6,6);
% for ii=1:6
%     splus=s;
%     splus(ii)=s(ii)+h;
%     smoins=s;
%     smoins(ii)=s(ii)-h;
%     gtildeplus=DPBgtilde(splus,psi); %ep,phi0,phif,psif,Bp);
%     gtildemoins=DPBgtilde(smoins,psi); %ep,phi0,phif,psif,Bp);
%     dgtildedsii=(gtildeplus-gtildemoins)/(2*h);
%     dgtildeds(:,ii)=dgtildedsii;
% end
% drsigdsig=eye(6)+Dlambda*Mo*dgtildeds;
% Jac(1:6,1:6)=drsigdsig;
% % second terme drsig/dep (dim = 6*1)
% % drsig/dep=dlambda*Mo*dm'/dep*I61
% % dm'/dep=dm'/dpsi*dpsi/dep
% dmdpsi=2*sqrt(3)*cos(psi)/(3-sin(psi))^2;
% dpsidep=(phif-phi0)*Bp/(Bp+ep)^2;
% drsigdep=Dlambda*dmdpsi*dpsidep*Mo*[1;1;1;0;0;0];
% Jac(1:6,7)=drsigdep;
% % troisieme terme drsig/dlambda (dim = 6*1)
% % drsig/dlambda=Mo*dgdsig=A2
% gtilde=DPBgtilde(s,psi); %ep,phi0,phif,psif,Bp);
% Jac(1:6,8)=Mo*gtilde;
% % quatrime terme drep/dsig=0 (dim = 1*6)
% % cinqime terme drep/drep=1 (dim = 1*1)
% Jac(7,7)=1;
% % sixime terme drep/dlambda = -val
% Jac(7,8)=-val;
% % septime terme drf/dsig = dfdsig
% m=2*sin(phi)/(sqrt(3)*(3-sin(phi)));
% dfdsig=m*[1;1;1;0;0;0]+devsig/(2*IIs);
% Jac(8,1:6)=dfdsig;
% % huitime terme drf/dep = dfdphi*dphidep
% dfdphi=2*Is/sqrt(3)*(cos(phi)/(3-sin(phi))+cos(phi)*sin(phi)/(3-sin(phi))^2)-6*C/sqrt(3)*(sin(phi)/(3-sin(phi))+cos(phi)^2/(3-sin(phi))^2);
% dphidep=(phif-phi0)/(Bp+ep)-ep*(phif-phi0)/(Bp+ep)^2;
% Jac(8,7)=dfdphi*dphidep;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% comparaison des 2 Jac
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% A=0;
% for i=1:8
%     for j=1:8
%         if Jac(i,j)~=0
%             B=abs(Jac2(i,j)-Jac(i,j))/abs(Jac(i,j));
%         else
%             if Jac2(i,j)~=0
%                 B=1;
%             end
%         end
%         if B>A
%             A=B;
%         end
%     end
% end
% 
% disp(A);