function [s,varint,convergence]=iso_trans(ntens,props,de,s0)
% modele DP ecrouissage isotrope
convergence=0;
% axe 1=r; axe 2=theta; axe 3=z
% tenseur colonne : rr, thetatheta, zz, thetaz, zr, rtheta
% donnees materiaux :
E1=props(2);
E2=props(3);
G1=props(4);
nu11=props(5);
nu12=props(6);
nu21=props(7);
%
%
if ntens==3
    de=[de(1:2);0;de(3)/2;0;0];
end
if ntens==4
    de=[de(1:3);de(4)/2;0;0];
    s0=[s0;0;0];
end
% calcul des cont et def
Mo=[1/E1,-nu11/E1,-nu12/E2,0,0,0;...
    -nu11/E1,1/E1,-nu12/E2,0,0,0;...
    -nu21/E1,-nu21/E1,1/E2,0,0,0;...
    0,0,0,1/G1,0,0;...
    0,0,0,0,1/G1,0;...
    0,0,0,0,0,(1+nu11)/E1];

ds=(Mo\de);
s=s0+ds;
% calcul de w2, w2n, nw2 (norme de dsig * norme de deps)
w2=de'*ds;
nw2=norm(de)*norm(ds);
w2n=w2/nw2;
%
varint=w2n;
%
if ntens==4
    s=s(1:4);
end