function eps=eps_sig(sig,props)
nc=size(props,2);

prec=1.e-6;
itermax=100;

% estimateur
%eps=zeros(6,1);
E=props(1);
nu=props(2);
Mo=zeros(6,6);
for k=1:3
    Mo(k,k)=E*(1-nu)/((1+nu)*(1-2*nu));
    Mo(k+3,k+3)=E/(1+nu);
end
for k=1:3
    for l=1:3
        if (k~=l)
            Mo(k,l)=E*nu/((1+nu)*(1-2*nu));
        end
    end
end

eps=Mo\sig;

if nc==4
    
    iter=0;
    crit=prec*100;
    
    while (crit > prec && iter<itermax)
        iter =iter+1;
        
        R = sig_eps(eps,props) - sig;
        J = d2psi_de2(eps,props);
        deps = -J\R;
        eps=eps+deps;
        
        crit=abs(R'*eps);
    end
end

%eps=-eps;