function Ot=VM_C(ntens,props,varint,s,activOt)
% modele DP ecrouissage isotrope
%props=[rho,E,nu,C,phi0,phif,psif,Bp,itermaxi,preci,activOt];
% donnees materiaux :
E=props(2);
nu=props(3);
sb=props(4);
Dlambda=varint(7);
%
if ntens==3
    s(4:6)=s(4:6)*sqrt(2);
end
if ntens==4
    s=[s;0;0];
    s(4)=s(4)*sqrt(2);
end
% mmoire de s et ep ini utilis dans la procdure de Newton
%%%%%%%%%%%%%%%%%%%%%
Mo=d2psi_de2(varint(1:6),[E,nu]);
P=[2/3,-1/3,-1/3,0,0,0;...
    -1/3,2/3,-1/3,0,0,0;...
    -1/3,-1/3,2/3,0,0,0;...
    0,0,0,2,0,0;...
    0,0,0,0,2,0;...
    0,0,0,0,0,2];

dgdsig=3/(2*sb)*P*s;
%
if (activOt == 1 || activOt == 3)
    % tgt consistant
    drsigdsig=eye(6)+3*Dlambda/(2*sb)*Mo*P;
    drsigdlambda=3/(2*sb)*Mo*P*s;
    drfdsig=3/(2*sb)*P*s;
    
    Jac=[drsigdsig,drsigdlambda;drfdsig',0];
    j=inv(Jac);
    Ot=j(1:6,1:6)*Mo;
end

if (activOt == 2 || activOt == 4)
    % tgt physique
    Ot=Mo-(Mo*dgdsig)*(dgdsig'*Mo) / (dgdsig'*(Mo*dgdsig));
end
%
if ntens == 4
    Ot=Ot(1:4,1:4);
end

if ntens == 3
    Ot=Ot([1:2,4],[1:2,4]);
end