function Ot=DPB_C(ntens,props,varint,s)
% modele DP ecrouissage isotrope
%props=[rho,E,nu,C,phi0,phif,psif,Bp,itermaxi,preci,activOt];
% donnees materiaux :
E=props(2);
nu=props(3);
C=props(4);
phi0=props(5);
phif=props(6);
psif=props(7);
Bp=props(8);

%
if ntens==4
    s=[s;0;0];
end
% mmoire de s et ep ini utilis dans la procdure de Newton
ep=varint(1);
Dlambda=varint(2);
%%%%%%%%%%%%%%%%%%%%%
Mo=d2psi_de2(s,[E,nu]);
%
if (Dlambda ~= 0)

    %     if (activOt == 1 || activOt == 3)
    %         % tgt consistant
    %         % calcul de la jacobienne :
    %         Jac=DPBJac(s,ep,Dlambda,C,phi0,phif,psif,Bp,Mo);
    %         j=inv(Jac);
    %         Ot=j(1:6,1:6)*Mo;
    %     end

    % tgt "physique"
    phi=phi0+(phif-phi0)*ep/(Bp+ep);

    Is=s(1)+s(2)+s(3);
    devsig=s-Is/3*[1;1;1;0;0;0];
    IIs=sqrt(0.5*(devsig'*devsig));

    m=2*sin(phi)/(sqrt(3)*(3-sin(phi)));
    dfdsig=m*[1;1;1;0;0;0]+devsig/(2*IIs);

    dfdphi=2*Is/sqrt(3)*(cos(phi)/(3-sin(phi))+cos(phi)*sin(phi)/(3-sin(phi))^2)-6*C/sqrt(3)*(sin(phi)/(3-sin(phi))+cos(phi)^2/(3-sin(phi))^2);
    dphidep=(phif-phi0)*Bp/(Bp+ep)^2;

    val=sqrt(3)/3;

    psi=phi-(phif-psif);
    gtilde=DPBgtilde(s,psi);
    Ot=Mo-(Mo*gtilde)*(dfdsig'*Mo) / (dfdsig'*(Mo*gtilde)-val*dfdphi*dphidep);
    
else
    Ot=Mo;
end
%
Ot(4:6,4:6)=Ot(4:6,4:6)/2; % car gamma_ij pour matrice rigidite
%
if ntens == 4
    Ot=Ot(1:4,1:4);
end

if ntens == 3
    Ot=Ot([1:2,4],[1:2,4]);
end