function [j,J1]=jacob(typ_el,X,dNxsi)
J=dNxsi*X;

% if strcmp('lig1',typ_el)==1
%     % Jacobienne 1D pour pb  2 DDL
%     % J=[dX/dxsi dY/dxsi]=[(x2-x1)/2, (y2-y1)/2];
%     j=sqrt(sum(J.^2));
%     J1=1/j;
% else
%     % Jacobienne 2D pour pb  2 ddl (dplacements ux, uy)
%     % X=[x1 y1;x2 y2;x3 y3]
%     % J=[dX/dxsi dY/dxsi;dX/deta dY/deta]=[dN1/dxsi dN2/dxsi dN3/dxsi;dN1/deta
%     % dN2/deta dN3/deta]*X
%     
%     J1=inv(J);
%     j=abs(det(J));
% end

switch typ_el
    case 'lig1'
        % Jacobienne 1D pour pb  2 DDL
        % J=[dX/dxsi dY/dxsi]=[(x2-x1)/2, (y2-y1)/2];
        j=sqrt(sum(J.^2));
        J1=1/j;
        
    case 'lig2'
        j=sqrt(sum(J.^2));
        J1=1/j;
    otherwise
        % Jacobienne 2D pour pb  2 ddl (dplacements ux, uy)
        % X=[x1 y1;x2 y2;x3 y3]
        % J=[dX/dxsi dY/dxsi;dX/deta dY/deta]=[dN1/dxsi dN2/dxsi dN3/dxsi;dN1/deta
        % dN2/deta dN3/deta]*X
        
        J1=inv(J);
        j=abs(det(J));
end