function res=interp_nod(TENS,coord,nel,typ_el,carel,connec)
% fonction qui  interpole les resultats aux noeuds depuis les points
% d'integration
% fonctionne bien si NPI=N_NOD: doit fonctionner sans rien changer si
% NPI>N_NOD (avec pseudo inverse du "\" de matlab)
%
% principe : soit sx la variable scalaire a interpoler
% sx(xpi,ypi) connu, sx(xnod,ynod) inconnu
% sx(xpi,ypi)=somme_nnod N(xpi,ypi)*sx(xnod,ynod)
% ceci est un systme carre si NPI=N_NOD que l'on inverse
%
% enfin, on fait la moyenne des valeurs aux noeuds pour la contribution de
% chaque element
%
% ce travail est fait dans chaque "zone" (maillage ou loi de comp
% differente), donc en fin de script on diminue la taille du vecteur global
% sur la zone concernee

if carel(1) > carel(3)
    switch typ_el
        case 'tri6'
            carel(1)=3;
            typ_el='tri3';
            connec=connec(:,1:3);
        case 'Q9'
            carel(1)=4;
            typ_el='Q4';
            connec=connec(:,1:4);
    end
end

ntens=size(TENS(:,1,1),1);
res=zeros(size(coord,1),2+ntens);
for iel=1:nel
    xnod=zeros(carel(1),1);
    ynod=zeros(carel(1),1);
    for inod=1:carel(1)
        xnod(inod)=coord(connec(iel,inod),1);
        ynod(inod)=coord(connec(iel,inod),2);
    end
    
    
    for ii=1:ntens
        sigii=zeros(carel(1),1);
        for ipi=1:carel(1)
            sigii(ipi)=TENS(ii,ipi,iel);
        end
%        sigiinod=sigii;
        TENSNOD(ii,:,iel)=sigii';
    end
end
% valeur moyenne aux noeuds
for inod=1:size(coord,1)
    [numel,numnod]=find(connec==inod);
    testvide=isempty(numel);
    signodmean=zeros(ntens,1);
    if testvide==0
        for ii = 1:size(numel,1)
            signodmean=signodmean+TENSNOD(:,numnod(ii),numel(ii));
        end
        signodmean=signodmean./size(numel,1);
        xy=coord(inod,:);
    else
        %xy=zeros(1,2);
        xy=ones(1,2)*1.e10;
    end
    res(inod,:)=[xy,signodmean'];
end
%ligtosup=find(ismember(res,zeros(1,2+ntens),'rows'));
ligtosup=find(ismember(res(:,1:2),ones(1,2)*1.e10,'rows'));
res(ligtosup,:)=[];