function J2_J2max=Taurel(s,ntens,props)

nb_pts=size(s,1);
invariants=zeros(nb_pts,3);

lcomp=size(props,2);

for k=1:nb_pts
    switch ntens
        case 3
            sig=[s(k,1) s(k,4) 0;...
                s(k,4) s(k,2) 0;...
                0 0 s(k,3)];

        case 4
            sig=[s(k,1) 0 s(k,4);...
                0 s(k,2) 0;...
                s(k,4) 0 s(k,3)];
    end
    invariants(k,1)=trace(sig);
    S=sig-invariants(k,1)/3*eye(3);
    invariants(k,2)=sqrt(1/2*trace(S*S));
    invariants(k,3)=1/3*trace(S*S*S);
end

switch lcomp
    case 19
        n=-0.229;
        C=props(5);
        phic=props(8);
        phie=props(12);
        rc=1/sqrt(3)*(2*sin(phic)/(3-sin(phic)));
        re=1/sqrt(3)*(2*sin(phie)/(3+sin(phie)));
        b=((rc/re)^(1/n)-1)/((rc/re)^(1/n)+1);
        a=rc/(1+b)^n;
        sin3b=-3*sqrt(3)/2*invariants(:,3)./(invariants(:,2)).^3;
        m=a*(1+b*sin3b).^n;
        J2max=-m.*(invariants(:,1)-3*C/tan(phic));

    case 10
        C=props(4);
        phic=props(6);
        m=2*sin(phic)/(sqrt(3)*(3-sin(phic)));
        J2max=-m*(invariants(:,1)-3*C/tan(phic));
end

J2_J2max=invariants(:,2)./J2max;