function [xsi,w]=PI(typ_el,npi,numPI)
%
switch typ_el
    case 'tri6'
        if npi==3
            switch numPI
                case 1
                   xsi=[1/6,1/6];
                   w=1/6;
                case 2
                    xsi=[2/3,1/6];
                    w=1/6;
                case 3
                    xsi=[1/6,2/3];
                    w=1/6;
            end
        end
        
        if npi==7
            a=0.470142064105115;
            b=0.101286507323456;
            p1=0.066197076394253;
            p2=0.062969590272413;
            switch numPI
                case 1
                    xsi=[b,b];
                    w=p2;
                case 2
                    xsi=[1-2*b,b];
                    w=p2;
                case 3
                    xsi=[b,1-2*b];
                    w=p2;
                case 4
                    xsi=[a,1-2*a];
                    w=p1;
                case 5
                    xsi=[a,a];
                    w=p1;
                case 6
                    xsi=[1-2*a,a];
                    w=p1;
                case 7
                    xsi=[1/3,1/3];
                    w=9/80;

            end
        end
            
    case 'Q9'
        if npi==4
            % position et poids des PI pour une intgration sur un quadrangle avec 4 points
            switch numPI
                case 1
                    xsi=[-1/sqrt(3),-1/sqrt(3)];
                    w=1;
                case 2
                    xsi=[1/sqrt(3),-1/sqrt(3)];
                    w=1;
                case 3
                    xsi=[1/sqrt(3),1/sqrt(3)];
                    w=1;
                case 4
                    xsi=[-1/sqrt(3),1/sqrt(3)];
                    w=1;
            end
        end
        if npi==9
            % position et poids des PI pour une intgration sur un quadrangle avec 9 points
            a=0.774596669241483;
            switch numPI
                case 1
                    xsi=[-a,-a];
                    w=25/81;
                case 2
                    xsi=[a,-a];
                    w=25/81;
                case 3
                    xsi=[a,a];
                    w=25/81;
                case 4
                    xsi=[-a,a];
                    w=25/81;
                case 5
                    xsi=[0,-a];
                    w=40/81;
                case 6
                    xsi=[a,0];
                    w=40/81;
                case 7
                    xsi=[0,a];
                    w=40/81;
                case 8
                    xsi=[-a,0];
                    w=40/81;
                case 9
                    xsi=[0,0];
                    w=64/81;
            end
        end
        
    case 'tri3'
        if npi==3
            % position et poids des PI pour une intgration sur triangle linaire avec
            % 3 points
            switch numPI
                case 1
                    xsi=[1/6,1/6];
                    w=1/6;
                case 2
                    xsi=[2/3,1/6];
                    w=1/6;
                case 3
                    xsi=[1/6,2/3];
                    w=1/6;
            end
        end
        
    case 'Q4'
        if npi==4
            % position et poids des PI pour une intgration sur triangle linaire avec
            % 4 points
            switch numPI
                case 1
                    xsi=[-1/sqrt(3),-1/sqrt(3)];
                    w=1;
                case 2
                    xsi=[1/sqrt(3),-1/sqrt(3)];
                    w=1;
                case 3
                    xsi=[1/sqrt(3),1/sqrt(3)];
                    w=1;
                case 4
                    xsi=[-1/sqrt(3),1/sqrt(3)];
                    w=1;
            end
        end
        
    case 'lig1'
        % position et poids des PI pour une intgration sur un segment linaire avec
        % 1 point ou 2 points
        if npi==1
            xsi=0;
            w=2;
        end
        if npi==2
            switch numPI
                case 1
                    xsi=-1/sqrt(3);
                    w=1;
                case 2
                    xsi=1/sqrt(3);
                    w=1;
            end
        end
        if npi==3
            switch numPI
                case 1
                    xsi=-0.774596669241483;
                    w=0.555555555555556;
                case 2
                    xsi=0;
                    w=0.888888888888889;
                case 3
                    xsi=0.774596669241483;
                    w=0.555555555555556;
            end
        end
        
    case 'lig2'
        % position et poids des PI pour une intgration sur un segment linaire avec
        % 1 point ou 2 points
        if npi==2
            switch numPI
                case 1
                    xsi=-1/sqrt(3);
                    w=1;
                case 2
                    xsi=1/sqrt(3);
                    w=1;
            end
        end
        if npi==3
            switch numPI
                case 1
                    xsi=-0.774596669241483;
                    w=0.555555555555556;
                case 2
                    xsi=0;
                    w=0.888888888888889;
                case 3
                    xsi=0.774596669241483;
                    w=0.555555555555556;
            end
        end
end