function Mo=Hook_ini(loi_comp,props,ntens)
% attention ici utilise pour matrice de rigidit donc loi de comportement
% avec les gamma_ij et non les epsilon_ij
switch loi_comp
    
    case 'houlsby'
        
    case 'ISO_TRANS'
        % modele isotrop transverse
        E1=props(2);
        E2=props(3);
        G1=props(4);
        nu11=props(5);
        nu12=props(6);
        nu21=props(7);
        
        Mo=[1/E1,-nu11/E1,-nu12/E2,0,0,0;...
            -nu11/E1,1/E1,-nu12/E2,0,0,0;...
            -nu21/E1,-nu21/E1,1/E2,0,0,0;...
            0,0,0,2/G1,0,0;...
            0,0,0,0,2/G1,0;...
            0,0,0,0,0,2*(1+nu11)/E1];
        Mo=inv(Mo);
        
    case 'ORTHO_LIN'
        % modele orthotrope
        E1=props(2);
        E2=props(3);
        E3=props(4);
        G1=props(5);
        G2=props(6);
        G3=props(7);
        nu12=props(8);
        nu13=props(9);
        nu21=props(10);
        nu23=props(11);
        nu31=props(12);
        nu32=props(13);
        
        Mo=[1/E1,-nu12/E2,-nu13/E3,0,0,0;...
            -nu21/E1,1/E2,-nu23/E3,0,0,0;...
            -nu31/E1,-nu32/E2,1/E3,0,0,0;...
            0,0,0,2/G1,0,0;...
            0,0,0,0,2/G2,0;...
            0,0,0,0,0,2/G3];
        Mo=inv(Mo);
        
    case 'DP2'
        % modele houlsby        
        E=props(1);
        nu=props(2);
        po=props(3);  % pression relative  l'atmosphre (ingnieurs)
        n=props(4);
        
        k=E/(3*(1-2*nu)*po);
        g=E/(2*(1+nu)*po);
        
        % valeurs drives
        A=po/(k*(2-n))*((1-n)*k)^((2-n)/(1-n));
        c=1/(k*(1-n));
        %c=0;
        d=3*g/(k*(1-n));
        % invariants des tenseurs
        %I=[1;1;1;0;0;0];
        %Ir2=[1;1;1;sqrt(2);sqrt(2);sqrt(2)];
        %ev=sum(eps(1:3));
        %deve=e.*Ir2-ev/3.*I;
        %deve=eps-ev/3*I;
        %es=sqrt(2/3)*sqrt(deve'*deve);
        %
        F=c^2;
        %G1=2*(ev+c)+2*d/3*(4/3*eps(1)-2/3*(eps(2)+eps(3))); % dF/de11
        %G2=2*(ev+c)+2*d/3*(4/3*eps(2)-2/3*(eps(1)+eps(3))); % dF/de22
        %G3=2*(ev+c)+2*d/3*(4/3*eps(3)-2/3*(eps(2)+eps(1))); % dF/de33
        %G=[G1;G2;G3];
        %H=eps(4:6)*4*d/3 ;       % dF/deij i/=j
        
        % matrice lastique tangente
        Mo=zeros(6,6);
        for i=1:3
            j=i+1;
            if i==3
                j=1;
            end
            Mo(i,i)=A*(2-n)/(2-2*n)*F^(n/(2-2*n))*(2+8*d/9);
            Mo(i+3,i+3)=(A*(2-n)/(2-2*n)*F^(n/(2-2*n))*(4*d/3))/2;
            Mo(i,j)=A*(2-n)/(2-2*n)*F^(n/(2-2*n))*(2-4*d/27);
            Mo(j,i)=1*Mo(i,j);
        end
        
    otherwise
        E=props(2);
        nu=props(3);
        Mo=E/((1+nu)*(1-2*nu))*[1-nu nu nu 0 0 0;...
                                nu 1-nu nu 0 0 0;...
                                nu nu 1-nu 0 0 0;...
                                0 0 0 (1-2*nu)/2 0 0;...
                                0 0 0 0 (1-2*nu)/2 0;...
                                0 0 0 0 0 (1-2*nu)/2];
end

if ntens==1
    Mo=Mo(1,1);
end
if ntens==3
    ind=[1,2,4];
    Mo=Mo(ind,ind);
end
if ntens==4
    Mo=Mo(1:4,1:4);
end