function Ot=PLR_C(ntens,props,varint,s)
% modele PLR ecrouissage isotrope
%props=[rho,E,nu,C,phi0,phif,psif,Bp,itermaxi,preci,activOt];
% donnees materiau :
E=props(2);
nu=props(3);
C0=props(4);
Cf=props(5);
Bc=props(6);
phic0=props(7);
phicf=props(8);
Bp=props(9);
psicf=props(10);
phie0=props(11);
phief=props(12);
psief=props(13);
epic=props(14);
phires=props(15);
psires=props(16);
bb=props(17);

%
if ntens==4
    s=[s;0;0];
end
% mmoire de s et ep ini utilis dans la procdure de Newton
epeq=varint(1);
Dlambda=varint(2);
%%%%%%%%%%%%%%%%%%%%%
Mo=d2psi_de2(s,[E,nu]);
%
if (Dlambda ~= 0)
    % tgt "physique"
    % puissance n de Van Eeckelen
    n=-0.229;
    % paramtres fonction pondration pour softening
    kr=phires/phicf;
    krpsi=psires/psicf;
    a=-bb/epic*(1-1/bb)^(1/bb)*1/(1-bb)^2*(((2*bb-1)/bb)^(2-1/bb)-(2*bb-1)/bb-(1-bb)^2/bb);

    C=C0+(Cf-C0)*epeq/(Bc+epeq);

    f1c=phic0+(phicf-phic0)*epeq/(Bp+epeq);
    fp=kr+(1-kr)*(1+(a*epeq)^bb)^(1/bb-1);
    fppsi=krpsi+(1-krpsi)*(1+(a*epeq)^bb)^(1/bb-1);
    phic=f1c*fp;
    psic=(f1c-(phicf-psicf))*fppsi; %(f1c-(phicf-psicf))*fp; %f1c-(phicf-psicf); %phic-(phicf-psicf);

    f1e=phie0+(phief-phie0)*epeq/(Bp+epeq);
    phie=f1e*fp;
    psie=(f1e-(phief-psief))*fppsi; %(f1e-(phief-psief))*fp; %f1e-(phief-psief); %phie-(phief-psief);

    Isig=s(1)+s(2)+s(3);
    devsig=s-Isig/3*[1;1;1;0;0;0];
    IIsig=sqrt(0.5*(devsig'*devsig));
    IIIsig = 1/3*(devsig(1)^3+devsig(2)^3+devsig(3)^3+...
        3/sqrt(2)*devsig(4)*devsig(5)*devsig(6)+...
        3/2*devsig(1)*(devsig(5)^2+devsig(6)^2)+...
        3/2*devsig(2)*(devsig(4)^2+devsig(6)^2)+...
        3/2*devsig(3)*(devsig(5)^2+devsig(4)^2));
    sin3b = -3*sqrt(3)*IIIsig/(2*IIsig^3);

    rc = 1/sqrt(3)*(2*sin(phic)/(3-sin(phic)));
    re = 1/sqrt(3)*(2*sin(phie)/(3+sin(phie)));
    b = ((rc/re)^(1/n)-1)/((rc/re)^(1/n)+1);
    a = rc/((1+b)^(n));
    m = a*(1+b*sin3b)^(n);

    rcg = 1/sqrt(3)*(2*sin(psic)/(3-sin(psic)));
    reg = 1/sqrt(3)*(2*sin(psie)/(3+sin(psie)));
    bg = ((rcg/reg)^(1/n)-1)/((rcg/reg)^(1/n)+1);
    ag = rcg/((1+bg)^(n));
    mg = ag*(1+bg*sin3b)^(n);

    dfdsin3b = a*b*n*(Isig - 3*C/tan(phic))*(1+b*sin3b)^(n-1);
    SikSkj =[devsig(1)^2+0.5*(devsig(6)^2+devsig(5)^2) ;...
        devsig(2)^2+0.5*(devsig(6)^2+devsig(4)^2) ;...
        devsig(3)^2+0.5*(devsig(4)^2+devsig(5)^2) ;...
        (devsig(3)+devsig(2))*devsig(4)+devsig(6)*devsig(5)/sqrt(2);...
        (devsig(3)+devsig(1))*devsig(5)+devsig(4)*devsig(6)/sqrt(2);...
        (devsig(1)+devsig(2))*devsig(6)+devsig(4)*devsig(5)/sqrt(2)];
    dsin3bdsig = -3*sqrt(3)/(2*IIsig^3)*(SikSkj-2/3*IIsig^2*[1;1;1;0;0;0]-3*IIIsig*devsig/(2*IIsig^2));
    dfdsig = m*[1;1;1;0;0;0] + devsig/(2*IIsig) + dfdsin3b*dsin3bdsig;

    dgdsin3b = ag*bg*n*(Isig - 3*C/tan(psic))*(1+bg*sin3b)^(n-1);
    dgdsig = mg*[1;1;1;0;0;0] + devsig/(2*IIsig) + dgdsin3b*dsin3bdsig;

    dfdc = -3*m/tan(phic);

    POL = ((sin(phic)*(3+sin(phie)))/(sin(phie)*(3-sin(phic))))^(1/n);
    A1 = (6*C-2*C*sin(phic))*(1-sin3b);
    A2 = 3*C*(1+sin3b-cos(2*phic)-sin3b*cos(2*phic))-...
        2*C*sin(phic)*(sin3b+1)+...
        Isig*sin(2*phic)*(1+sin3b);
    NUM1 = sqrt(3)/sin(phic)*(A1+POL*A2)*(1+sin3b*(POL-1)/(POL+1))^(n);
    DENO1 = 2^(n)*(sin(phic)-3)^2*(POL/(1+POL))^(n)*(1-sin3b+POL*(1+sin3b));
    NUM2 = 2*sqrt(3)*(sin3b-1)/tan(phie)*...
        (Isig*sin(phic)-3*C*cos(phic))*(1+sin3b*(POL-1)/(POL+1))^(n);
    DENO2 = 2^(n)*(sin(phic)-3)*(sin(phie)+3)*(POL/(1+POL))^(n)*(1-sin3b+POL*(1+sin3b));

    dfdphic = NUM1/DENO1;
    dfdphie = NUM2/DENO2;

    df1cdepeq = (phicf-phic0)/(Bp+epeq)-(phicf-phic0)/((Bp+epeq)^2)*epeq;
    dfpdepeq = (1-kr)*a^bb*(1-bb)*epeq^(bb-1)*(1+(a*epeq)^bb)^(1/bb-2);
    dphicdepeq = df1cdepeq*fp + f1c*dfpdepeq;

    df1edepeq = (phief-phie0)/(Bp+epeq)-(phief-phie0)/((Bp+epeq)^2)*epeq;
    dphiedepeq = df1edepeq*fp + f1e*dfpdepeq;
    dcdepeq = (Cf-C0)/(Bc+epeq)-(Cf-C0)/((Bc+epeq)^2)*epeq;

    val = sqrt(2/3*(dgdsig'*dgdsig-1/3*(sum(dgdsig(1:3)))^2));


    gtilde=PLRgtilde(s,psic,psie,n,C);
    Ot=Mo-(Mo*gtilde)*(dfdsig'*Mo) / (dfdsig'*(Mo*gtilde)-val*(dfdphic*dphicdepeq+dfdphie*dphiedepeq+dfdc*dcdepeq));

else
    Ot=Mo;
end
%
%Ot(4:6,4:6)=Ot(4:6,4:6)/2; % car gamma_ij pour matrice rigidite
Ot(:,4:6)=Ot(:,4:6)/2; % car gamma_ij pour matrice rigidite
%
if ntens == 4
    Ot=Ot(1:4,1:4);
end

if ntens == 3
    Ot=Ot([1:2,4],[1:2,4]);
end