function [s,varint,convergence]=ortho_lin(ntens,props,de,s0)
% modele DP ecrouissage isotrope
convergence=0;
%props=[rho,E,nu];
% donnees materiaux :
E1=props(2);
E2=props(3);
E3=props(4);
G1=props(5);
G2=props(6);
G3=props(7);
nu12=props(8);
nu13=props(9);
nu21=props(10);
nu23=props(11);
nu31=props(12);
nu32=props(13);
%
if ntens==3
    de=[de(1:2);0;de(3)/2;0;0];
end
if ntens==4
    de=[de(1:3);de(4)/2;0;0];
    s0=[s0;0;0];
end
% calcul des cont et def  
Mo=[1/E1,-nu12/E2,-nu13/E3,0,0,0;...
    -nu21/E1,1/E2,-nu23/E3,0,0,0;...
    -nu31/E1,-nu32/E2,1/E3,0,0,0;...
    0,0,0,1/G1,0,0;...
    0,0,0,0,1/G2,0;...
    0,0,0,0,0,1/G3];
ds=(Mo\de);
s=s0+ds;
% calcul de w2, w2n, nw2 (norme de dsig * norme de deps)
w2=de'*ds;
nw2=norm(de)*norm(ds);
w2n=w2/nw2;
%
varint=w2n;
%
if ntens==4
    s=s(1:4);
end