% output
% post traitement
% construction du tableau de rsultat en chaque PI pour 1 pas de calcul

% option af_mail=1 maillage, 2 maillage + no noeuds, 3 maillage + no elem,
% 4 maillage + no noeuds et no elem.
clear;
clc;
close all;

addpath (genpath('/Users/fprunier/Documents/recherche/code_EF/code_matlab/ANA_2203_sol_structure/sources'));
load('postt_pp');
%load('postt_triax_nd.mat');

af_mail=1;

pasres=3;
Ut=Usoltot{pasres};

nb_zone=size(Sol,1);
nddl=size(Ut,1);

for izone=1:nb_zone
    connec=Sol{izone,3};
    typ_el=Sol{izone,2}{1};
    carel=Sol{izone,2}{2};
    nel=size(connec,1);

    Ux=Ut(1:2:nddl-1);
    Uy=Ut(2:2:nddl);
    XY=coord(1:size(Ux,1),:)+[Ux,Uy]*10;
    
    if af_mail~=0
        affich_mail(coord,af_mail,'blue',connec,typ_el,1);
        affich_mail(XY,af_mail,'red',connec,typ_el,1);
    end
        
    SIG=Sol{izone,6}{pasres};
    EPS=Sol{izone,5}{pasres};
    
    res1=interp_nod(SIG,[coord(:,1),coord(:,2)],nel,typ_el,carel,connec);
    res2=interp_nod(EPS,[coord(:,1),coord(:,2)],nel,typ_el,carel,connec);
    res=[res1,res2(:,3:end)];
    
    x=res(:,1);
    y=res(:,2);
    
    if ntens==3
        sxx=res(:,3)*(-1e-3);
        syy=res(:,4)*(-1e-3);
        szz=res(:,5)*(-1e-3);
        sxy=res(:,6)*(-1e-3);
        exx=res(:,9)*1e2;
        eyy=res(:,10)*1e2;
        exy=res(:,11)*1e2;
    elseif ntens==4
        sxx=res(:,3)*(-1e-3);
        syy=res(:,4)*(-1e-3);
        szz=res(:,5)*(-1e-3);
        sxy=res(:,6)*(-1e-3);
        exx=res(:,7)*1e2;
        eyy=res(:,8)*1e2;
        exy=res(:,10)*1e2;
    end


    [X,Y]=meshgrid(x,y);

    Z=griddata(x,y,syy,X,Y);
    figure(3)
    hold on
    A=pcolor(X,Y,Z);
    A.ZData=A.CData;
    colormap 'jet' ;
    shading 'interp'
    colorbar;
    axis 'equal';
    title('\sigma_{yy} (kP_a)')
end