function P_por=tens_cap(Xpi,gamma_w,loi_comp,props,Mate,y0,typ_sym)
% calculer Xpi avec Xpi=sum Ni(xsi,eta)*Xi
% puis calculer Sige(Xpi) avec suction et variable interne si il y'en a
% à faire
%
% calcul du tenseur capillaire
if Xpi(2) <= y0
    P_por=gamma_w*(y0-Xpi(2))*[ones(3,1);zeros(3,1)];
else
    switch loi_comp
        case 'constant'
            P_por=Mate;       % tenseur capillaire
        case 'Prunier_Arairo'
            a=props(2);
            b=props(3);
            pref=props(4);
            evol_succion=Mate; %succion fonction de y
            y=evol_succion(:,1);
            s=evol_succion(:,2);
            ypi=Xpi(2);
            % interpolation lineaire entre les deux valeurs encadrant
            % ypi
            [~,ind1]=min(abs(y-ypi));
            if y(ind1)>ypi
                ind2=ind1-1;
            else
                ind2=ind1+1;
            end
            y1=y(ind1);
            y2=y(ind2);
            s1=s(ind1);
            s2=s(ind2);
            spi=(ypi-y1)/(y2-y1)*s2+(ypi-y2)/(y1-y2)*s1;
            P_por=spi/(1+(a*spi/pref)^b)^(1-1/b)*[ones(3,1);zeros(3,1)];
    end
    if strcmp(typ_sym,'axi')==1
        P_por=P_por(1:4);
    end
end
%