function [Ksol,Sol,typ_elsurf,carelsurf,ntens]=SOL_ini(Sol,coord,nb_sol,nddl,typ_sym,npastot)

Ksol=zeros(nddl,nddl);
for isol=1:nb_sol
    Sol{isol,5}=cell(npastot,1);
    Sol{isol,6}=cell(npastot,1);
    Sol{isol,7}=cell(npastot,1);
    Sol{isol,8}=cell(npastot,1);
    typ_el=Sol{isol,2}{1};
    carel=Sol{isol,2}{2};
    connec=Sol{isol,3};
    nel=size(connec,1);
    Mate=Sol{isol,1};
    varint0=[Mate{3},0];
    nvarint=max(size(varint0));
    %
    switch typ_el %,'tri3'
        % caracteristiques element :
        % nnoel,nddlno,npi : nb noeuds par elements, nb ddl par noeuds, nb points
        % integrations par elements
        case 'tri6'
            typ_elsurf='lig2';
            carelsurf=[3,2,3];
        case 'Q9'
            typ_elsurf='lig2';
            carelsurf=[3,2,3];
        case 'tri3'
            typ_elsurf='lig1';
            carelsurf=[2,2,2]; % npi = 2 pour intégration exacte d'une répartition de contrainte linéaire. Si répartition plus compliquée : augmenter npi
        case 'Q4'
            typ_elsurf='lig1';
            carelsurf=[2,2,2];
    end
    % initialisation des tableaux Eps et Sig du sol isol
    if strcmp(typ_sym,'axi')==1
        ntens=4; %taille "vecteur" tenseur cf cours ef cesti
        Eps=zeros(ntens,carel(3),nel); % tableau a 3 dim:
        Sig=zeros(ntens,carel(3),nel); % lignes = ntens, colonnes = npi, pages = nel
    end
    if strcmp(typ_sym,'defp')==1
        ntens=3;
        Eps=zeros(ntens,carel(3),nel); % tableau a 3 dim:
        Sig=zeros(6,carel(3),nel); % lignes = composante, colonnes = npi, pages = nel
    end
    Sol{isol,5}{1}=Eps;
    Sol{isol,6}{1}=Sig;
    % initialisation variables internes
    varint=zeros(nvarint,carel(3),nel); % tableau a 3 dim
    x=find(varint0 ~=0);
    if any(x)
        for ii=1:max(size(x))
            varint(x(ii),:,:)=varint0(x(ii));
        end
    end
    % lignes = nvarint, colonnes = npi, pages = nel
    % les données doivent etre dans ce sens pour les affectations en remontee dans le code
    % et idem pour les tenseurs, cela permet d'avoir des objet dont le profil diminue en
    % fct des affectations par elements puis par point d'integration.
    %
    Sol{isol,7}{1}=varint;
    %
    % coordonnées et PI
    Sol{isol,9}=coord_PI(typ_el,coord,connec,nel,carel);
    %
    % matrice elastique initiale:
    Mo=Hook_ini(Mate{1},Mate{2},ntens);
    % initialisation matrice rigidite en chaque PI
    C=cell(nel,carel(3));
    for ii=1:nel
        for jj=1:carel(3)
            C{ii,jj}=Mo;
        end
    end
    Ksol=Ktot(coord,connec,C,nel,typ_el,carel,Ksol,typ_sym);
end

% Ksol=sparse(Ksol);