% trace phisoft
phi0=5;
phif=36;
psif=5;
Bp=0.001;
epic=0.03;
phires=30;
psires=1;
b=5;

ep=0:0.001:0.2;

kr=phires/phif;
a=-b/epic*(1-1/b)^(1/b)*1/(1-b)^2*(((2*b-1)/b)^(2-1/b)-(2*b-1)/b-(1-b)^2/b);
fp=kr+(1-kr)*(1+(a*ep).^b).^(1/b-1);

krpsi=psires/psif;
fppsi=krpsi+(1-krpsi)*(1+(a*ep).^b).^(1/b-1);

figure(10)
hold on
plot(ep,fp)
grid on
xlabel('epeq');
ylabel('fp');


phi=(phi0+(phif-phi0)./(Bp+ep).*ep).*fp;
psi=((phi0+(phif-phi0)./(Bp+ep).*ep)-(phif-psif)).*fppsi; %phi-(phif-psif);
figure(20)
hold on
plot(ep,phi)
grid on
xlabel('epeq');
ylabel('phi (°)');

figure(30)
hold on
plot(ep,psi)
grid on
xlabel('epeq');
ylabel('psi (°)');


f1c=(phi0+(phif-phi0)./(Bp+ep).*ep);
df1cdepeq = (phif-phi0)./(Bp+ep)-(phif-phi0)./((Bp+ep).^2).*ep;
dfpdepeq = (1-kr)*a^b*(1-b)*ep.^(b-1).*(1+(a*ep).^b).^(1/b-2);
dphicdepeq = df1cdepeq.*fp + f1c.*dfpdepeq;

figure(40)
hold on
plot(ep,dphicdepeq)
grid on
xlabel('epeq');
ylabel('dphi/depeq');