function [Kcl,Fcl]=CL_Lagrange(Kt,Ft,nod,nddlno,dep,dirU,option)
%
nnod=size(nod,1);
% quation : c1*U1+c2*U2+...+cn*Un=g
% conditionnnement : on multiplie l'quation par un coef du mme ordre de
% grandeur que celui des termes diagonaux
alpha = trace(Kt)/size(Kt,1);


switch option
    case 'homogene' % on asservi tous les noeuds d'un bord  se dplacer de
        % manire identique dans une ou toutes les directions.
        % Ces directions sont fixes par le vecteur dirU rempli
        % de 1 ou 0 uniquement
        dir_homo=find(dirU);
        i_rela=0;
        for idir=1:size(dir_homo,2)
            Fcl=[Ft;zeros(nnod-1,1)];
            esp_rela=zeros(nnod-1,size(Kt,1));
            Kcl=[Kt;esp_rela];
            esp_rela=zeros(size(Kcl,1),nnod-1);
            Kcl=[Kcl,esp_rela];
            %ddl_cible=(nod(nnod)-1)*nddlno+dir_homo(idir); % noeud du bord  qui seront asservi tous les autres (le dernier de la liste)
            ddl_cible=(nod(1)-1)*nddlno+dir_homo(idir); % noeud du bord  qui seront asservi tous les autres (le premier de la liste)
            for i=2:nnod  %1:nnod-1
                i_rela=i_rela+1;
                ligne=i_rela+size(Kt,1);
                colonne=(nod(i)-1)*nddlno+dir_homo(idir);
                %Fcl(ligne)=dep(i)*alpha;
                Kcl(ligne,colonne)=alpha;
                Kcl(colonne,ligne)=alpha;
                Kcl(ligne,ddl_cible)=-alpha;
                Kcl(ddl_cible,ligne)=-alpha;
            end
        end
        
    case 'lag2no' % on attribue une condition cinmatique entre 2 noeuds du
        % type : a1*Ux1+a2*Ux2+b1*Uy1+b2*Uy2+c1*Uz1+c2*Uz2=g
        % il faut videmment multiplier cette relation par alpha
        % dep = valeur de g
        % nod = [nod1,nod2]
        % dirU = [ a1,a2,...,c1,c2];
        Fcl=[Ft;alpha*dep];
        esp_rela=zeros(1,size(Kt,1));
        Kcl=[Kt;esp_rela];
        esp_rela=zeros(size(Kcl,1),1);
        Kcl=[Kcl,esp_rela];
        for iddl=1:nddlno
            ligne=size(Kcl,1);
            col1=(nod(1)-1)*nddlno+iddl;
            col2=(nod(2)-1)*nddlno+iddl;
            Kcl(ligne,col1)=alpha*dirU(iddl);
            Kcl(col1,ligne)=alpha*dirU(iddl);
            Kcl(ligne,col2)=alpha*dirU(nddlno+iddl);
            Kcl(col2,ligne)=alpha*dirU(nddlno+iddl);
        end
        
    case 'homogene2' %double lagrange. on asservi tous les noeuds d'un bord  se dplacer de
        % manire identique dans une ou toutes les directions.
        % Ces directions sont fixes par le vecteur dirU rempli
        % de 1 ou 0 uniquement
        dir_homo=find(dirU);
        i_rela=0;
        for idir=1:size(dir_homo,2)
            Fcl=[Ft;zeros(2*(nnod-1),1)];
            esp_rela=zeros(2*(nnod-1),size(Kt,1));
            Kcl=[Kt;esp_rela];
            esp_rela=zeros(size(Kcl,1),2*(nnod-1));
            Kcl=[Kcl,esp_rela];
            %ddl_cible=(nod(nnod)-1)*nddlno+dir_homo(idir); % noeud du bord  qui seront asservi tous les autres (le dernier de la liste)
            ddl_cible=(nod(1)-1)*nddlno+dir_homo(idir); % noeud du bord  qui seront asservi tous les autres (le premier de la liste)
            for i=2:nnod  %1:nnod-1
                i_rela=i_rela+1;
                ligne1=2*i_rela-1+size(Kt,1);
                ligne2=2*i_rela+size(Kt,1);
                colonne=(nod(i)-1)*nddlno+dir_homo(idir);

                % termes de la conditions cin
                Kcl(ligne1,colonne)=alpha;
                Kcl(colonne,ligne1)=alpha;
                Kcl(ligne1,ddl_cible)=-alpha;
                Kcl(ddl_cible,ligne1)=-alpha;
                Kcl(ligne2,colonne)=alpha;
                Kcl(colonne,ligne2)=alpha;
                Kcl(ligne2,ddl_cible)=-alpha;
                Kcl(ddl_cible,ligne2)=-alpha;
                % termes des doubles lagrange
                Kcl(ligne1,ligne1)=-alpha;
                Kcl(ligne1,ligne1+1)=alpha;
                Kcl(ligne2,ligne2)=-alpha;
                Kcl(ligne2,ligne2-1)=alpha;
            end
        end
        
    case 'lag2no2' %double lagrange. on attribue une condition cinmatique entre 2 noeuds du
        % type : a1*Ux1+a2*Ux2+b1*Uy1+b2*Uy2+c1*Uz1+c2*Uz2=g
        % il faut videmment multiplier cette relation par alpha
        % dep = valeur de g
        % nod = [nod1,nod2]
        % dirU = [ a1,a2,...,c1,c2];
        Fcl=[Ft;alpha*dep;alpha*dep];
        esp_rela=zeros(2,size(Kt,2));
        Kcl=[Kt;esp_rela];
        esp_rela=zeros(size(Kcl,1),2);
        Kcl=[Kcl,esp_rela];
        for iddl=1:nddlno
            ligne1=size(Kcl,1)-1;
            ligne2=ligne1+1;
            col1=(nod(1)-1)*nddlno+iddl;
            col2=(nod(2)-1)*nddlno+iddl;
            % termes de la conditions cin
            Kcl(ligne1,col1)=alpha*dirU(iddl);
            Kcl(col1,ligne1)=alpha*dirU(iddl);
            Kcl(ligne1,col2)=alpha*dirU(nddlno+iddl);
            Kcl(col2,ligne1)=alpha*dirU(nddlno+iddl);
            Kcl(ligne2,col1)=alpha*dirU(iddl);
            Kcl(col1,ligne2)=alpha*dirU(iddl);
            Kcl(ligne2,col2)=alpha*dirU(nddlno+iddl);
            Kcl(col2,ligne2)=alpha*dirU(nddlno+iddl);
            % termes des doubles lagrange
            Kcl(ligne1,ligne1)=-alpha;
            Kcl(ligne1,ligne1+1)=alpha;
            Kcl(ligne2,ligne2)=-alpha;
            Kcl(ligne2,ligne2-1)=alpha;
        end
end