function dsde=d2psi_de2(eps,props)
% matrice tangente elastique
nc=size(props,2);
switch nc
    case 2
        % loi de Hook
        E=props(1);
        nu=props(2);
        dsde=E/((1+nu)*(1-2*nu))*[1-nu nu nu 0 0 0;...
            nu 1-nu nu 0 0 0;...
            nu nu 1-nu 0 0 0;...
            0 0 0 (1-2*nu) 0 0;...
            0 0 0 0 (1-2*nu) 0;...
            0 0 0 0 0 (1-2*nu)];
        
    case 6
        % modele isotrop transverse
        E1=props(1);
        E2=props(2);
        G1=props(3);
        nu11=props(4);
        nu12=props(5);
        nu21=props(6);
        
        Mo=[1/E1,-nu11/E1,-nu12/E2,0,0,0;...
            -nu11/E1,1/E1,-nu12/E2,0,0,0;...
            -nu21/E1,-nu21/E1,1/E2,0,0,0;...
            0,0,0,1/G1,0,0;...
            0,0,0,0,1/G1,0;...
            0,0,0,0,0,(1+nu11)/E1];
        dsde=inv(Mo);
        
    case 12
        % loi othotrope lineaire
        E1=props(1);
        E2=props(2);
        E3=props(3);
        G1=props(4);
        G2=props(5);
        G3=props(6);
        nu12=props(7);
        nu13=props(8);
        nu21=props(9);
        nu23=props(10);
        nu31=props(11);
        nu32=props(12);
        
        Mo=[1/E1,-nu12/E2,-nu13/E3,0,0,0;...
            -nu21/E1,1/E2,-nu23/E3,0,0,0;...
            -nu31/E1,-nu32/E2,1/E3,0,0,0;...
            0,0,0,1/G1,0,0;...
            0,0,0,0,1/G2,0;...
            0,0,0,0,0,1/G3];
        dsde=inv(Mo);
        
    case 4
        % modele houlsby
        %eps=-eps;
        
        E=props(1);
        nu=props(2);
        po=props(3);  % pression relative  l'atmosphre (ingnieurs)
        n=props(4);
        
        k=E/(3*(1-2*nu)*po);
        g=E/(2*(1+nu)*po);
        
        % valeurs drives
        A=po/(k*(2-n))*((1-n)*k)^((2-n)/(1-n));
        d=3*g/(k*(1-n));
        % invariants des tenseurs
        I=[1;1;1;0;0;0];
        ev=sum(eps(1:3));
        deve=eps-ev/3*I;
        es=sqrt(2/3)*sqrt(deve'*deve);
        %
        F=ev^2+d*es^2;
        %
        % formule analytique trouvee dernierement / Mais semble poser qq pb
        % numerique lorsqu'on utilise matrice tgte elasto-plastique (et pas
        % uniquement elastique)
        T1=ev*I+2/3*d*deve;
        TT1=T1*T1';
        M1=A*n*(2-n)/(1-n)^2*F^((3*n-2)/(2-2*n))*TT1;
        %
        T2=(1-2/9*d)*ones(3,3);
        TT2=[T2,zeros(3,3);zeros(3,3),zeros(3,3)]+2/3*d*eye(6);
        M2=A*(2-n)/(1-n)*F^(n/(2-2*n))*TT2;
        dsde=M1+M2;
        
        % formule analytique trouvee initialement (marche bien mais ne
        % semble pas bonne analytiquement)
%         G1=2*ev+2*d/3*(4/3*eps(1)-2/3*(eps(2)+eps(3))); % dF/de11
%         G2=2*ev+2*d/3*(4/3*eps(2)-2/3*(eps(1)+eps(3))); % dF/de22
%         G3=2*ev+2*d/3*(4/3*eps(3)-2/3*(eps(2)+eps(1))); % dF/de33
%         G=[G1;G2;G3];
%         H=eps(4:6)*4*d/3 ;       % dF/deij i/=j
%         
%         % matrice lastique tangente
%         dsde=zeros(6,6);
%         for i=1:3
%             j=i+1;
%             if i==3
%                 j=1;
%             end
%             dsde(i,i)=A*(2-n)/(2-2*n)*F^(n/(2-2*n))*(2+8*d/9)+A*n*(2-n)/(2-2*n)^2*G(i)^2*F^((3*n-2)/(2-2*n));
%             dsde(i+3,i+3)=A*(2-n)/(2-2*n)*F^(n/(2-2*n))*(4*d/3)+A*n*(2-n)/(2-2*n)^2*H(i)^2*F^((3*n-2)/(2-2*n));
%             dsde(i,j)=A*(2-n)/(2-2*n)*F^(n/(2-2*n))*(2-4*d/27)+A*n*(2-n)/(2-2*n)^2*G(i)*G(j)*F^((3*n-2)/(2-2*n));
%             dsde(j,i)=1*dsde(i,j);
%         end
        
         % formule du papier de Houlsby
%          sig=A*(2-n)/(1-n)*F^(n/(2-2*n))*[G;H];
%          T1=sig*sig';
%          T2=[ones(3,3),zeros(3,3);zeros(3,3),zeros(3,3)];
%          dsde=po^n*(n*k/po^2*T1+k*(1-n)*T2+2*g*eye(6)-2*g/3*T2);
end