function nod_el=gmsh_nod_el(connec) %,typ_el)
% fonction qui fait la liste des noeuds d'un ensemble d'elements lineiques
% la liste des noeuds est ordonnée selo,n l'abscisse curviligne afin que
% toute evolution de force, deplacement ou pression soit correctement
% representée

if connec(1,1)==connec(end,2) % test si la ligne est ouverte ou fermée
    ligne=0;
else
    ligne=1;
end

if size(connec,2)==2 % si elements lineaires
    nod_el=connec(:,1);
    if ligne==1
        nod_el=[nod_el;connec(end,2)];
    end
else % si elements quadratiques
    nod_el=zeros(size(connec,1)*2+1,1);
    nod_el(1)=connec(1,1);
    nod_el(2:2:end-1)=connec(:,3);
    nod_el(3:2:end)=connec(:,2);
    if ligne==0
        nod_el=nod_el(1:end-1);
    end
end



% % fonction qui fait la liste des noeuds d'un ensemble d'elements
% nb_el=size(connec,1);
% %nod_el=zeros(nb_el,1); % nb no > nb el, mais on a aumoins ceci
% nnodel=size(connec,2); % nb no par elements
% 
% nod_el=connec(1,1:nnodel)';
% compt=nnodel;
% for k=2:nb_el
%     for j=1:nnodel
%         numnod=connec(k,j);
%         if isempty(find(~(nod_el-numnod),1))
%             compt=compt+1;
%             nod_el(compt)=numnod;
%         end
%     end
% end
% 
% if exist('typ_el','var')
%     if (isequal(typ_el,'tri6') || isequal(typ_el,'Q9'))
%         a=nod_el(2:2:end);
%         b=nod_el(3:2:end);
%         nod_el(2:2:end)=b;
%         nod_el(3:2:end)=a;
%     end
% end