function [DFeint,DEpse,DSige,varinte,convergence]=Fintelem(typ_el,typ_sym,carel,X,npi,ntens,DUe,Sige,Mate,varinte)
%
nnoel=carel(1);
nddlno=carel(2);
loi_comp=Mate{1};
props=Mate{2};
% force elementaire interieure
DFeint=zeros(size(DUe));
DEpse=zeros(ntens,npi);
%
if (strcmp(typ_sym,'defp')==1)
    DSige=zeros(6,npi);
else
    DSige=zeros(ntens,npi);
end
convergence=zeros(npi,2);
for k=1:npi
    [xsi,w]=PI(typ_el,npi,k);
    dNxsi=df_form(typ_el,xsi);
    [j,J1]=jacob(typ_el,X,dNxsi);
    B=mat_B(dNxsi,J1,typ_el);
    if strcmp(typ_sym,'axi')==1
        Nxsi=f_form(typ_el,xsi); % cf cours EF cesti pour matrice B en axisymtrie
        R=Nxsi*X(:,1);    % et matrice elementaire
        e_theta=zeros(1,nddlno*nnoel);
        for ii=1:nnoel
            e_theta(2*ii-1)=Nxsi(ii)/R;
        end
        B=[B(1,:);e_theta;B(2:end,:)];
    end
    DEpse(:,k)=B*DUe;
    %
    switch loi_comp
        case 'HOOK'
            [DSige(:,k),varinte(:,k),convergence_npi]=hook(ntens,props,DEpse(:,k),Sige(:,k));
        case 'DP'
            [DSige(:,k),varinte(:,k),convergence_npi]=DP_main(ntens,props,varinte(:,k),DEpse(:,k),Sige(:,k));
        case 'DPB'
            [DSige(:,k),varinte(:,k),convergence_npi]=DPB_main(ntens,props,varinte(:,k),DEpse(:,k),Sige(:,k));
        case 'PLR'
            [DSige(:,k),varinte(:,k),convergence_npi]=PLR_main(ntens,props,varinte(:,k),DEpse(:,k),Sige(:,k));
        case 'DPBUR'
            [DSige(:,k),varinte(:,k),convergence_npi]=DPBUR_main(ntens,props,varinte(:,k),DEpse(:,k),Sige(:,k));
        case 'DPBCAP'
            [DSige(:,k),varinte(:,k),convergence_npi]=DPBCAP_main(ntens,props,varinte(:,k),DEpse(:,k),Sige(:,k));
        case 'DPH'
            [DSige(:,k),varinte(:,k),convergence_npi]=DPH_main(ntens,props,varinte(:,k),DEpse(:,k),Sige(:,k));
        case 'VM'
            [DSige(:,k),varinte(:,k),convergence_npi]=VM_main(ntens,props,varinte(:,k),DEpse(:,k),Sige(:,k));
        case 'ORTHO_LIN'
            [DSige(:,k),varinte(:,k),convergence_npi]=ortho_lin(ntens,props,DEpse(:,k),Sige(:,k));
        case 'ISO_TRANS'
            [DSige(:,k),varinte(:,k),convergence_npi]=iso_trans(ntens,props,DEpse(:,k),Sige(:,k));
    end
    %
    if strcmp(typ_sym,'axi')==1 % si pb axi sym
        DFeint=DFeint+2*pi*w*j*R*B'*DSige(:,k);
    elseif strcmp(typ_sym,'defp')==1 % si pb def plane
        DFeint=DFeint+w*j*B'*[DSige(1,k);DSige(2,k);DSige(4,k)];
    else                             % autres cas
        DFeint=DFeint+w*j*B'*DSige(:,k);
    end
    convergence(k,:)=[k,convergence_npi];
end