% input
clear;
clc;
%close all;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% fichier mesh si necessaire
fic_mail='1Q4.msh';
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rep_courant=what;
rep_courant=rep_courant.path;
%fic_mail=[rep_courant,'/',fic_mail];
%
addpath (rep_courant);
addpath (genpath('/Users/fprunier/Documents/recherche/code_EF/code_matlab/ANA_2203_sol_structure/sources'));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% il faut renumeroter si on excave et/ou ajoute des elements de structure
% externe au maillage du sol
% Attention il faut absolument ajouter une '*' en premier signe de tout
% 'physical_name' d'un element de poutre externe au maillage du sol
% fic_mail=gmsh_renum2(fic_mail);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% type de problme :
% axi = axi sym, defp = def plane
typ_sym='axi';
%
renum_mail=0; % si = 1 on utilise symrcm pour matrice bandes, sinon pas de renumrotation
%
% %%%%%%%%%%%%%%%%%
% donne matriaux
% %%%%%%%%%%%%%%%%%
Sol=cell(1,8);
%mat1
rho=2.e3;
E=100.e6;
nu=0.25;
C0=0;
C=0; %100.e3; %0;
Bc=0.002;
phi0=35; %2;
phif=35;
Bp=0.0005;
psif=-1;%2;
phie0=35; %2;
phief=35;
psief=-1; %0.1;%2;
epic=2;
phires=35;
psires=0;
b=3.5;
itermaxi=200;
preci=1.e-6;
%
phi0=phi0*pi/180;
phif=phif*pi/180;
psif=psif*pi/180;
phie0=phie0*pi/180;
phief=phief*pi/180;
psief=psief*pi/180;
phires=phires*pi/180;
psires=psires*pi/180;
%
props=[rho,E,nu,C0,C,Bc,phi0,phif,Bp,psif,phie0,phief,psief,epic,phires,psires,b,itermaxi,preci];
% initialisation variables internes
varint0=0;
Mate{1}='PLR';
Mate{2}=props;
Mate{3}=varint0;
Sol{1,1}=Mate;
% maillage
cellfich=gmsh_mail(fic_mail);
coord=gmsh_coord(cellfich);
% type d'lments et table connectivites
% Sol = elements fixes
% Struc = elements qui sont actives a chaque phase du calcul et assemble avec
% des multiplicatezurs de Lagranges
Sol{1,2}={'Q4',[4,2,4]}; % typ element, nb no/elt,nddl/no, nb point integration
Sol{1,3}=gmsh_connec(cellfich,'"sol"'); % tab connec
%
% Phasage du calcul et CL
% nb d'tape = nnb de phase o les CL, voir le maillage peux changer
netap=2;
ETAP=cell(netap,6);
%%%%%%%%%%%%%%%%
%%%% etape 1
%%%%%%%%%%%%%%%%
chargement=-100.e3;
% bord CL (U impos)
% remarque importante : on applique les incrments de deplacement
nbcl=2; % nb de bord avec cl, ou relation cin. impose
elem=gmsh_connec(cellfich,'"bas"');
no=gmsh_nod_el(elem);
CL{1,1}=no;
CL{1,2}=2;   % no du ddl du noeud sur le quel on impose un deplacment
CL{1,3}='Dimp';
CL{1,4}=ones(size(CL{1,1})); % rpartition spatiale de la valeur du dplacement sur chaque noeud
CL{1,5}=zeros(size(chargement)); % attention la rpartition temporelle doit avoir la mme taille pour chaque CL ou FL

elem=gmsh_connec(cellfich,'"gauche"');
no=gmsh_nod_el(elem);
CL{2,1}=no;
CL{2,2}=1;
CL{2,3}='Dimp';
CL{2,4}=ones(size(CL{2,1}));
CL{2,5}=zeros(size(chargement));

% bord chargement (F impos)
% remarque importante : on applique les incrments de Force, contraintes...
nbfl=2; % nb de bord avec cl de type force, contrainte ou dep impose, ou application d'un force de volume
FL=cell(nbfl,6);
nbfcl=2; % nb de bord avec cl de type contrainte impose (pour construction des lments de bord).
elem=gmsh_connec(cellfich,'"haut"');
FL{1,1}=gmsh_nod_el(elem); % liste de noeuds chargement 1
FL{1,2}=[0,1]; % ddl sur le quel le chargement 1 agit (ici direction x) ( on peut mettre un vecteur de norme 1 pour dfinir un vecteur quelconque : par exemple normal  une surface incline)
FL{1,3}='Cimp'; % type d'action ici contrainte impose (mettre Fimp pour imposer les forces aux noeuds).
FL{1,4}=ones(size(FL{1,1})); % volution spatiale du chargement 1 (nodal : valeur physique de la dep ou pression  la position des noeuds)
FL{1,5}=chargement; % volution temporelle du chargement 1
%
elem=gmsh_connec(cellfich,'"droite"');
FL{2,1}=gmsh_nod_el(elem); % liste de noeuds chargement 1
FL{2,2}=[1,0]; % ddl sur le quel le chargement 1 agit (ici direction x) ( on peut mettre un vecteur de norme 1 pour dfinir un vecteur quelconque : par exemple normal  une surface incline)
FL{2,3}='Cimp'; % type d'action ici contrainte impose (mettre Fimp pour imposer les forces aux noeuds).
FL{2,4}=ones(size(FL{2,1})); % volution spatiale du chargement 1 (nodal : valeur physique de la dep ou pression  la position des noeuds)
FL{2,5}=chargement; % volution temporelle du chargement 1
%
ETAP{1,1}=nbcl;
ETAP{1,2}=CL;
ETAP{1,3}=nbfl;
ETAP{1,4}=nbfcl;
ETAP{1,5}=FL;
%
%%%%%%%%%%%%%%%%
%%%% etape 2
%%%%%%%%%%%%%%%%
chargement=-5e-2*ones(1,1000)/1000;
% bord CL (U impos)
% remarque importante : on applique les incrments de deplacement
nbcl=4; % nb de bord avec cl, ou relation cin. impose
elem=gmsh_connec(cellfich,'"bas"');
no=gmsh_nod_el(elem);
CL{1,1}=no;
CL{1,2}=2;   % no du ddl du noeud sur le quel on impose un deplacment
CL{1,3}='Dimp';
CL{1,4}=ones(size(CL{1,1})); % rpartition spatiale de la valeur du dplacement sur chaque noeud
CL{1,5}=zeros(size(chargement)); % attention la rpartition temporelle doit avoir la mme taille pour chaque CL ou FL
%
elem=gmsh_connec(cellfich,'"gauche"');
no=gmsh_nod_el(elem);
CL{2,1}=no;
CL{2,2}=1;
CL{2,3}='Dimp';
CL{2,4}=ones(size(CL{2,1}));
CL{2,5}=zeros(size(chargement));
%
elem=gmsh_connec(cellfich,'"haut"');
no=gmsh_nod_el(elem);
CL{3,1}=no;
CL{3,2}=2;
CL{3,3}='Dimp';
CL{3,4}=ones(size(CL{3,1}));
CL{3,5}=chargement;
%
elem=gmsh_connec(cellfich,'"droite"');
no=gmsh_nod_el(elem);
CL{4,1}=no;
CL{4,2}=1;
CL{4,3}='Dimp';
CL{4,4}=ones(size(CL{4,1}));
CL{4,5}=-0.5*chargement;
%
% bord chargement (F impos)
% remarque importante : on applique les incrments de Force, contraintes...
nbfl=0; % nb de bord avec cl de type force, contrainte ou dep impose, ou application d'un force de volume
FL=cell(nbfl,6);
nbfcl=0; % nb de bord avec cl de type contrainte impose (pour construction des lments de bord).
FL{1,6}=gmsh_connec(cellfich,'"haut"');
FL{1,1}=gmsh_nod_el(FL{1,6}); % liste de noeuds chargement 1
FL{1,2}=[0,1]; % ddl sur le quel le chargement 1 agit (ici direction x) ( on peut mettre un vecteur de norme 1 pour dfinir un vecteur quelconque : par exemple normal  une surface incline)
FL{1,3}='Cimp'; % type d'action ici contrainte impose (mettre Fimp pour imposer les forces aux noeuds).
FL{1,4}=ones(size(FL{1,1})); % volution spatiale du chargement 1 (nodal : valeur physique de la dep ou pression  la position des noeuds)
FL{1,5}=chargement; % volution temporelle du chargement 1
%
ETAP{2,1}=nbcl;
ETAP{2,2}=CL;
ETAP{2,3}=nbfl;
ETAP{2,4}=nbfcl;
ETAP{2,5}=FL;
% precision globale
activOt=1;
prec=1.e-6;
itermax=200;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% appel du programme
principal;
save('postt_triax_nd');