function N=f_form(typ_el,xsi)

switch typ_el
    case 'tri6'
        N=[
            (1-xsi(1)-xsi(2))*(1-2*xsi(1)-2*xsi(2)),...
            xsi(1)*(2*xsi(1)-1),...
            xsi(2)*(2*xsi(2)-1),...
            4*xsi(1)*(1-xsi(1)-xsi(2)),...
            4*xsi(1)*xsi(2),...
            4*xsi(2)*(1-xsi(1)-xsi(2))
            ];
        
    case 'Q9'
        N=1/4*[xsi(1)*xsi(2)*(xsi(1)-1)*(xsi(2)-1),...
            xsi(1)*xsi(2)*(xsi(1)+1)*(xsi(2)-1),...
            xsi(1)*xsi(2)*(xsi(1)+1)*(xsi(2)+1),...
            xsi(1)*xsi(2)*(xsi(1)-1)*(xsi(2)+1),...
            (1-xsi(1)^2)*xsi(2)*(xsi(2)-1)*2,...
            xsi(1)*(xsi(1)+1)*(1-xsi(2)^2)*2,...
            (1-xsi(1)^2)*xsi(2)*(xsi(2)+1)*2,...
            xsi(1)*(xsi(1)-1)*(1-xsi(2)^2)*2,...
            (1-xsi(1)^2)*(1-xsi(2)^2)*4];
    case 'lig2'
        N=[-0.5*(1-xsi)*xsi,0.5*(1+xsi)*xsi,(1+xsi)*(1-xsi)];
    case 'tri3'
        % fonction de forme (matrice N) 2D triangle linaire (3 noeuds) pour pb  2 ddl
        % matrice 1*3
        N=[1-xsi(1)-xsi(2),xsi(1),xsi(2)];
    case 'Q4'
        % fonction de forme (matrice N) 2D rectangle linaire (4 noeuds) pour pb  2 ddl
        % matrice 1*4
        N=[1/4*(1-xsi(1))*(1-xsi(2)),1/4*(1+xsi(1))*(1-xsi(2)),1/4*(1+xsi(1))*(1+xsi(2)),1/4*(1-xsi(1))*(1+xsi(2))];
    case 'lig1'
        % fonction de forme 1d linaire  2 noeuds
        N=0.5*[1-xsi,1+xsi];
end