% output
% post traitement
% construction du tableau de rsultat en chaque PI pour 1 pas de calcul

% option af_mail=1 maillage, 2 maillage + no noeuds, 3 maillage + no elem,
% 4 maillage + no noeuds et no elem.
clear;
clc;
close all;

addpath (genpath('/Users/fprunier/Documents/recherche/code_EF/code_matlab/ANA_2203_sol_structure/sources'));
load('postt_paroi');

af_mail=1; % option affichage maillage 1 maillage, 2 + num noeuds, 3 num eleme, 4 + num elem et noeuds
resPI=1; % option affichage aux PI plus prcis mais moins beau, sinon interpolation aux noeuds

pasres=31; %31;
Ut=Usoltot{pasres};
Ut0=Usoltot{1};

nb_zone=1;
nddl=size(Ut,1);

% construction des polygones a enlever pour surface non convexe
Pol=cell(nb_zone,1);
Pol{1}=[0.01 0.01;20 0.01;20 5;0.01 5];
%
for izone=1:nb_zone
    connec=Sol{izone,3};
    typ_el=Sol{izone,2}{1};
    carel=Sol{izone,2}{2};
    nel=size(connec,1);

    Ux=Ut(1:2:nddl-1);
    Uy=Ut(2:2:nddl);
    Ux0=Ut0(1:2:nddl-1);
    Uy0=Ut0(2:2:nddl);
    XY0=coord(1:size(Ux,1),:)+[Ux0,Uy0];
    XY=XY0+[Ux-Ux0,Uy-Uy0]*1;
    
    if af_mail~=0
        affich_mail(XY0,af_mail,'blue',connec,typ_el,1);
        affich_mail(XY,af_mail,'red',connec,typ_el,1);
    end
    
    SIG=Sol{izone,6}{pasres};
    EPS=Sol{izone,5}{pasres};
    VARINT=Sol{izone,7}{pasres};
    W2=Sol{izone,8}{pasres};
    if resPI==1
        XPI=Sol{izone,9};
        xy=tab_res(XPI);
        sig=tab_res(SIG);
        eps=tab_res(EPS);
        epeq=tab_res(VARINT(1,:,:))*1e2;
        w2n=tab_res(W2(1,:,:));
    else
        sig=interp_nod(SIG,[coord(:,1),coord(:,2)],nel,typ_el,carel,connec);
        xy=sig(:,1:2);
        sig=sig(:,3:end);
        eps=interp_nod(EPS,[coord(:,1),coord(:,2)],nel,typ_el,carel,connec);
        eps=eps(:,3:end);
        epeq=interp_nod(VARINT,[coord(:,1),coord(:,2)],nel,typ_el,carel,connec);
        epeq=epeq(:,3);
        w2n=interp_nod(W2,[coord(:,1),coord(:,2)],nel,typ_el,carel,connec);
        w2n=w2n(:,3);
    end
    props=Sol{izone,1}{2};
    taurel=Taurel(sig,ntens,props);
    
    if ntens==3
        sxx=sig(:,1)*(-1e-3);
        syy=sig(:,2)*(-1e-3);
        szz=sig(:,3)*(-1e-3);
        sxy=sig(:,4)*(-1e-3);
        exx=eps(:,1)*1e2;
        eyy=eps(:,2)*1e2;
        exy=eps(:,3)*1e2;
    elseif ntens==4
        sxx=sig(:,1)*(-1e-3);
        syy=sig(:,3)*(-1e-3);
        sxy=sig(:,4)*(-1e-3);
        exx=eps(:,1)*1e2;
        eyy=eps(:,3)*1e2;
        exy=eps(:,4)*1e2;
    end
    
    xmin=min(coord_sol(:,1));
    xmax=max(coord_sol(:,1));
    xg=xmin:(xmax-xmin)/200:xmax;
    ymin=min(coord_sol(:,2));
    ymax=max(coord_sol(:,2));
    yg=ymin:(ymax-ymin)/200:ymax;
    [X,Y]=meshgrid(xg,yg);
    xp=Pol{izone};
    if any(xp)
        in=inpolygon(X,Y,xp(:,1),xp(:,2));
    else
        in=[];
    end

    Z=griddata(xy(:,1),xy(:,2),syy,X,Y);
    Z(in)=NaN;
    figure(2)
    hold on
    A=pcolor(X,Y,Z);
    A.ZData=A.CData;
    %caxis([0 200]);
    colormap 'jet' ;
    shading 'interp'
    colorbar;
    axis 'equal';
    title('\sigma_{yy} (kP_a)')

    Z=griddata(xy(:,1),xy(:,2),sxx,X,Y);
    Z(in)=NaN;
    figure(3)
    hold on
    A=pcolor(X,Y,Z);
    A.ZData=A.CData;
    %caxis([0 170]);
    colormap 'jet' ;
    shading 'interp'
    colorbar;
    axis 'equal';
    title('\sigma_{xx} (kP_a)')

    Z=griddata(xy(:,1),xy(:,2),epeq,X,Y);
    Z(in)=NaN;
    figure(4)
    hold on
    A=pcolor(X,Y,Z);
    A.ZData=A.CData;
    %caxis([0 20]);
    colormap 'jet' ;
    shading 'interp'
    colorbar;
    axis 'equal';
    title('\epsilon_{p}^{eq} (%)')

    Z=griddata(xy(:,1),xy(:,2),w2n,X,Y);
    Z(in)=NaN;
    figure(5)
    hold on
    A=pcolor(X,Y,Z);
    A.ZData=A.CData;
    caxis([-1,1]);
    colormap ([colormap(winter) ; colormap(autumn)]);
    shading 'interp'
    colorbar;
    axis 'equal';
    title('w_{2n}')

    Z=griddata(xy(:,1),xy(:,2),taurel,X,Y);
    Z(in)=NaN;
    figure(6)
    hold on
    A=pcolor(X,Y,Z);
    A.ZData=A.CData;
    caxis([0,1]);
    colormap 'jet' ;
    shading 'interp'
    colorbar;
    axis 'equal';
    title('\tau_{rel}')
end

figure(7)
plot(W2Ntot,'o-');
grid on